////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.spark;

import java.util.TreeMap;

public class Spark
{
    private static TreeMap<String, SparkCommand> commands = new TreeMap<String, SparkCommand>();

    private static void loadCommands()
    {
        commands.put("sow", new SOWCommand("sow"));
        commands.put("ping", new PingCommand("ping"));
        commands.put("publish", new PublishCommand("publish"));
        commands.put("subscribe", new SubscribeCommand("subscribe"));
        commands.put("sow_and_subscribe", new SOWAndSubscribeCommand("sow_and_subscribe"));
        commands.put("sow_delete", new SOWDeleteCommand("sow_delete"));
        commands.put("help", new HelpCommand("help", commands));
    }

    public static void main(String[] args) throws Exception
    {
        loadCommands();

        // Must be at least one arg to be valid, or just execute the help.
        if(args.length < 1)
        {
            commands.get("help").help();
            System.exit(0);
        }

        String command = args[0];

        if(!commands.containsKey(command))
        {
            commands.get("help").help();
            System.err.println("Error: command '" + command + "' is not valid.");
            System.exit(1);
        }

        // We have a command, let's jump right in
        commands.get(command).execute(args);
        System.exit(0);
    }
}
