////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.spark;

import java.util.TreeMap;

public class HelpCommand extends SparkCommand
{
    private TreeMap<String, SparkCommand> commands = null;

    public HelpCommand(String name, TreeMap<String, SparkCommand> commands)
    {
        super(name);
        this.commands = commands;
        this.options.clear();
        this.required.clear();
        this.optional.clear();
        
        // Add example
        StringBuilder example = new StringBuilder(1024);
        example.append("  % ./spark help sow\n");
        example.append("  Returns the help and usage information for the 'sow' command.\n");
        addExample(example.toString());

        // Add extra info
        StringBuilder extra = new StringBuilder(1024);
        extra.append("Supported Commands:\n");
        extra.append("\n");
        extra.append("  help\n");
        for (String commandName : commands.keySet())
        {
            extra.append("  " + commandName + "\n");
        }
        addExtra(extra.toString());

        // Usage
        setUsage("spark help [command]");
    }

    void execute(String argv[])
    {
        if(argv.length < 2)
        {
            this.help();
        }
        else
        {
            String command = argv[1];
            if(commands.containsKey(command))
            {
                commands.get(command).help();
            }
            else
            {
                System.err.println("Error: command '" + command + "' not found.");
                System.exit(1);
            }
        }
    }

}
