////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////
package com.crankuptheamps.spark;
import com.crankuptheamps.client.Authenticator;
import com.crankuptheamps.client.exception.AuthenticationException;

/**
 * For command line custom authenticator support in spark. An implemnter of this interface is loaded using
 * Class.forName when the fully qualified class name is specified via the -authenticator parameter on the spark command line.
 * This class is instantiated and its createAuthenticator() method is invoked to create an Authenticator object for logging on.
 * @author David
 *
 */
public interface AuthenticatorFactory
{
    /**
     * Create an Authenticator object to use for logging on. See DefaultAuthenticatorFactory for example implementation.
     * 
     * @param connectionURI the unparsed uri that this authenticator should be prepared to authenticate with. 
     * @return A new Authenticator instance
     * @throws AuthenticationException Thrown if an Authenticator cannot be created.
     */
    public Authenticator createAuthenticator(String connectionURI) throws AuthenticationException; 
}
