////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client.fields;

public class IntegerField extends Field
{
    protected static final byte   LATIN1_ZERO  = 48;

    private byte[] bytes = new byte[11]; // LOG10(2**32)<10 (+1 for sign)

    public int getValue()
    {
        if(this.buffer != null)
        {
            int result = 0;
            for(int i = position; i < position+length; ++i)
            {
                result = result * 10 + (buffer[i] - LATIN1_ZERO);
            }
            return result;
        }
        else
        {
            throw new NullPointerException("value is null");
        }
    }
    public void setValue(int v)
    {
        int index  = 0;
        if(v < 0)       // handle the sign
        {
            bytes[index++] = '-';
            v = -v;
        }
        int cv = v;
        while(cv > 0)
        {
            cv /= 10;    // TODO: Faster than Log10?
            ++index;
        }
        int length = index;
        while(v > 0)
        {
            bytes[--index] = (byte)(LATIN1_ZERO+(v%10));
            v /= 10;
        }
        set(bytes,0,length);
    }
}

