////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client.fields;

public class Field
{
    public byte[] buffer   = null;
    public int    position = 0;
    public int    length   = 0;

    public Field()
    {
    }

    public Field(String value)
    {
        try
        {
            byte[] bytes = value.getBytes("US-ASCII");
            this.buffer = bytes;
            this.position = 0;
            this.length = buffer.length;
        }
        catch (Exception exception)
        {
        }
    }

    public Field(byte[] buffer, int position, int length)
    {
        set(buffer, position, length);
    }

    public void set(byte[] buffer,int position,int length)
    {
        this.buffer   = buffer;
        this.position = position;
        this.length   = length;
    }
    public void set(byte[] buffer)
    {
        this.buffer   = buffer;
        this.position = 0;
        this.length   = buffer.length;
    }
    public boolean isNull()
    {
        return this.buffer == null || this.length == 0;
    }

    public void reset()
    {
        this.buffer   = null;
        this.length   = 0;
    }

    public byte byteAt(int i)
    {
        return this.buffer[this.position + i];
    }

    // for large sets of short, similar byte sequences this can produce lots of collision
    public int hashCode()
    {
        int result = 0;
        for(int i = 0; i < length; i++)
        {
            result += buffer[position+i];
        }
        return result;
    }

    public boolean equals(Object obj)
    {
        if(obj == null || !(obj instanceof Field))
        {
            return false;
        }
        Field o = (Field)obj;
        if(o.length != length) return false;
        for(int i=0; i< length; i++)
        {
            if(o.buffer[o.position+i] != buffer[position+i]) return false;
        }
        return true;
    }

    public Field copy()
    {
        byte[] copy = null;
        if (buffer != null) {
            copy = new byte[length];
            System.arraycopy(buffer, position, copy, 0, length);
        }
        return new Field(copy, 0, length);
    }

    public String toString()
    {
        StringBuilder sb = new StringBuilder();
        for(int i = position; i < position + length; i++)
        {
            sb.append((char)buffer[i]);
        }
        return sb.toString();
    }

    public void copyFrom(Field f) {
        if (buffer == null || f.length > buffer.length) {
            buffer = new byte[f.length];
        }
        System.arraycopy(f.buffer, f.position, buffer, 0, f.length);
        position = 0;
        length = f.length;
    }


}


