////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client;

import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

import com.crankuptheamps.client.fields.AckTypeField;
import com.crankuptheamps.client.fields.BooleanField;
import com.crankuptheamps.client.fields.CommandField;
import com.crankuptheamps.client.fields.Field;
import com.crankuptheamps.client.fields.IntegerField;
import com.crankuptheamps.client.fields.LongField;
import com.crankuptheamps.client.fields.ReasonField;
import com.crankuptheamps.client.fields.StatusField;
import com.crankuptheamps.client.fields.StringField;
import com.crankuptheamps.client.fields.BookmarkField;


public class XMLMessage extends Message
{
    /*  Example message
    <?xml version="1.0" encoding="iso-8859-1"?><SOAP-ENV:Envelope>
        <SOAP-ENV:Header>
            <TxmTm>20070212-15:50:31-0500</TxmTm>
            <CmdId>1</CmdId>
            <Cmd>publish</Cmd>
            <Tpc>trade</Tpc>
            <MsgTyp>xml</MsgTyp>
            <UsrId>jmb</UsrId>
        </SOAP-ENV:Header>
        <SOAP-ENV:Body>
            <FIXML v="4.4" r="20030618" s="20040109">
                <Order ID="12345" Side="2" TxnTm="2001-09-11T09:30:47-05:00" Typ="2" Px="90.00" Acct="26522154">
                    <Hdr Snt="2001-09-11T09:30:47-05:00" PosDup="N" PosRsnd="N" SeqNum="200" SID="AFUNDMGR" TID="ABROKER"/>
                    <Instrmt Sym="IBM" ID="459200101" Src="1"/>
                    <OrdQty Qty="100"/>
                </Order>
            </FIXML>
        </SOAP-ENV:Body>
    </SOAP-ENV:Envelope>
    */


    private static final String LATIN1        = "ISO-8859-1";
    private static byte[] TG_XML_MESSAGE_PROLOG = null;
    private static byte[] TG_XML_MESSAGE_MID    = null;
    private static byte[] TG_XML_MESSAGE_EPILOG = null;

    private static byte[] TG_ACKTYPE           = null;
    private static byte[] TG_ACKTYPE_X         = null;
    private static byte[] TG_BATCHSIZE         = null;
    private static byte[] TG_BATCHSIZE_X       = null;
    private static byte[] TG_BOOKMARK          = null;
    private static byte[] TG_BOOKMARK_X        = null;
    private static byte[] TG_CLIENTNAME        = null;
    private static byte[] TG_CLIENTNAME_X      = null;
    private static byte[] TG_COMMAND           = null;
    private static byte[] TG_COMMAND_X         = null;
    private static byte[] TG_COMMANDID         = null;
    private static byte[] TG_COMMANDID_X       = null;
    private static byte[] TG_CORRELATION_ID    = null;
    private static byte[] TG_CORRELATION_ID_X  = null;
    private static byte[] TG_EXPIRATION        = null;
    private static byte[] TG_EXPIRATION_X      = null;
    private static byte[] TG_FILTER            = null;
    private static byte[] TG_FILTER_X          = null;
    private static byte[] TG_ORDERBY           = null;
    private static byte[] TG_ORDERBY_X         = null;
    private static byte[] TG_MAXMESSAGES       = null;
    private static byte[] TG_MAXMESSAGES_X     = null;
    private static byte[] TG_OPTIONS           = null;
    private static byte[] TG_OPTIONS_X         = null;
    private static byte[] TG_QUERYID           = null;
    private static byte[] TG_QUERYID_X         = null;
    private static byte[] TG_RECORDSINSERTED   = null;
    private static byte[] TG_RECORDSINSERTED_X = null;
    private static byte[] TG_RECORDSUPDATED    = null;
    private static byte[] TG_RECORDSUPDATED_X  = null;
    private static byte[] TG_RECORDSDELETED    = null;
    private static byte[] TG_RECORDSDELETED_X  = null;
    private static byte[] TG_RECORDSRETURNED   = null;
    private static byte[] TG_RECORDSRETURNED_X = null;
    private static byte[] TG_SENDEMPTIES       = null;
    private static byte[] TG_SENDEMPTIES_X     = null;
    private static byte[] TG_SENDMATCHINGIDS   = null;
    private static byte[] TG_SENDMATCHINGIDS_X = null;
    private static byte[] TG_SENDOOF           = null;
    private static byte[] TG_SENDOOF_X         = null;
    private static byte[] TG_SEQUENCE          = null;
    private static byte[] TG_SEQUENCE_X        = null;
    private static byte[] TG_SOWKEYS           = null;
    private static byte[] TG_SOWKEYS_X         = null;
    private static byte[] TG_STATUS            = null;
    private static byte[] TG_STATUS_X          = null;
    private static byte[] TG_SUBID             = null;
    private static byte[] TG_SUBID_X           = null;
    private static byte[] TG_TIMESTAMP         = null;
    private static byte[] TG_TIMESTAMP_X       = null;
    private static byte[] TG_TOPIC             = null;
    private static byte[] TG_TOPIC_X           = null;
    private static byte[] TG_TOPN              = null;
    private static byte[] TG_TOPN_X            = null;
    private static byte[] TG_USERID            = null;
    private static byte[] TG_USERID_X          = null;
    private static byte[] TG_PASSWORD          = null;
    private static byte[] TG_PASSWORD_X        = null;
    private static byte[] TG_VERSION           = null;
    private static byte[] TG_VERSION_X         = null;

    static
    {
        try
        {
            //TG_XML_MESSAGE_PROLOG = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><SOAP-ENV:Envelope><SOAP-ENV:Header>".getBytes(LATIN1);
            TG_XML_MESSAGE_PROLOG = "<?xml version=\"1.0\"?><SOAP-ENV:Envelope><SOAP-ENV:Header>".getBytes(LATIN1);
            TG_XML_MESSAGE_MID    = "</SOAP-ENV:Header><SOAP-ENV:Body>".getBytes(LATIN1);
            TG_XML_MESSAGE_EPILOG = "</SOAP-ENV:Body></SOAP-ENV:Envelope>".getBytes(LATIN1);
            TG_ACKTYPE            = "<AckTyp>".getBytes(LATIN1);
            TG_ACKTYPE_X          = "</AckTyp>".getBytes(LATIN1);
            TG_BATCHSIZE          = "<BtchSz>".getBytes(LATIN1);
            TG_BATCHSIZE_X        = "</BtchSz>".getBytes(LATIN1);
            TG_BOOKMARK           = "<BkMrk>".getBytes(LATIN1);
            TG_BOOKMARK_X         = "</BkMrk>".getBytes(LATIN1);
            TG_CLIENTNAME         = "<ClntName><![CDATA[".getBytes(LATIN1);
            TG_CLIENTNAME_X       = "]]></ClntName>".getBytes(LATIN1);
            TG_COMMAND            = "<Cmd>".getBytes(LATIN1);
            TG_COMMAND_X          = "</Cmd>".getBytes(LATIN1);
            TG_COMMANDID          = "<CmdId>".getBytes(LATIN1);
            TG_COMMANDID_X        = "</CmdId>".getBytes(LATIN1);
            TG_CORRELATION_ID     = "<CrlId><![CDATA[".getBytes(LATIN1);
            TG_CORRELATION_ID_X   = "]]></CrlId>".getBytes(LATIN1);
            TG_EXPIRATION         = "<Expn>".getBytes(LATIN1);
            TG_EXPIRATION_X       = "</Expn>".getBytes(LATIN1);
            TG_FILTER             = "<Fltr><![CDATA[".getBytes(LATIN1);
            TG_FILTER_X           = "]]></Fltr>".getBytes(LATIN1);
            TG_ORDERBY            = "<OrderBy>".getBytes(LATIN1);
            TG_ORDERBY_X          = "</OrderBy>".getBytes(LATIN1);
            TG_MAXMESSAGES        = "<MxMsgs>".getBytes(LATIN1);
            TG_MAXMESSAGES_X      = "</MxMsgs>".getBytes(LATIN1);
            TG_OPTIONS            = "<Opts>".getBytes(LATIN1);
            TG_OPTIONS_X          = "</Opts>".getBytes(LATIN1);
            TG_QUERYID            = "<QId>".getBytes(LATIN1);
            TG_QUERYID_X          = "</QId>".getBytes(LATIN1);
            TG_RECORDSINSERTED    = "<RecordsInserted>".getBytes(LATIN1);
            TG_RECORDSINSERTED_X  = "</RecordsInserted>".getBytes(LATIN1);
            TG_RECORDSUPDATED     = "<RecordsUpdated>".getBytes(LATIN1);
            TG_RECORDSUPDATED_X   = "</RecordsUpdated>".getBytes(LATIN1);
            TG_RECORDSDELETED     = "<RecordsDeleted>".getBytes(LATIN1);
            TG_RECORDSDELETED_X   = "</RecordsDeleted>".getBytes(LATIN1);
            TG_RECORDSRETURNED    = "<RecordsReturned>".getBytes(LATIN1);
            TG_RECORDSRETURNED_X  = "</RecordsReturned>".getBytes(LATIN1);
            TG_SENDEMPTIES        = "<SndEmpty>".getBytes(LATIN1);
            TG_SENDEMPTIES_X      = "</SndEmpty>".getBytes(LATIN1);
            TG_SENDMATCHINGIDS    = "<SndSubIds>".getBytes(LATIN1);
            TG_SENDMATCHINGIDS_X  = "</SndSubIds>".getBytes(LATIN1);
            TG_SENDOOF            = "<SndOOF>".getBytes(LATIN1);
            TG_SENDOOF_X          = "</SndOOF>".getBytes(LATIN1);
            TG_SEQUENCE           = "<Seq>".getBytes(LATIN1);
            TG_SEQUENCE_X         = "</Seq>".getBytes(LATIN1);
            TG_SOWKEYS            = "<SowKeys>".getBytes(LATIN1);
            TG_SOWKEYS_X          = "</SowKeys>".getBytes(LATIN1);
            TG_STATUS             = "<Status>".getBytes(LATIN1);
            TG_STATUS_X           = "</Status>".getBytes(LATIN1);
            TG_SUBID              = "<SubId><![CDATA[".getBytes(LATIN1);
            TG_SUBID_X            = "]]></SubId>".getBytes(LATIN1);
            TG_TIMESTAMP          = "<TxmTm>".getBytes(LATIN1);
            TG_TIMESTAMP_X        = "</TxmTm>".getBytes(LATIN1);
            TG_TOPIC              = "<Tpc><![CDATA[".getBytes(LATIN1);
            TG_TOPIC_X            = "]]></Tpc>".getBytes(LATIN1);
            TG_TOPN               = "<TopN>".getBytes(LATIN1);
            TG_TOPN_X             = "</TopN>".getBytes(LATIN1);
            TG_USERID             = "<UsrId><![CDATA[".getBytes(LATIN1);
            TG_USERID_X           = "]]></UsrId>".getBytes(LATIN1);
            TG_PASSWORD           = "<PW><![CDATA[".getBytes(LATIN1);
            TG_PASSWORD_X         = "]]></PW>".getBytes(LATIN1);
            TG_VERSION            = "<Version>".getBytes(LATIN1);
            TG_VERSION_X          = "</Version>".getBytes(LATIN1);
        }
        catch(UnsupportedEncodingException e)
        {
            //Absorb... these should never throw for ASCII
        }
    }

    public XMLMessage(CharsetEncoder encoder,
                      CharsetDecoder decoder)
    {
        super(encoder, decoder);
    }

    final private void serializeMessageProperty(ByteBuffer b,
            byte[] opentag,
            byte[] endtag,
            Field  field)
    {
        if(field.buffer != null)
        {
            b.put(opentag);
            b.put(field.buffer,field.position,field.length);
            b.put(endtag);
        }
    }

    public SerializationResult serialize(ByteBuffer b)
    {
        try
        {
            b.put(TG_XML_MESSAGE_PROLOG);

            serializeMessageProperty(b,TG_COMMAND,TG_COMMAND_X,_Command);
            serializeMessageProperty(b,TG_COMMANDID,TG_COMMANDID_X,_CommandId);
            serializeMessageProperty(b,TG_CLIENTNAME,TG_CLIENTNAME_X,_ClientName);
            serializeMessageProperty(b,TG_CORRELATION_ID,TG_CORRELATION_ID_X,_CorrelationId);
            serializeMessageProperty(b,TG_USERID,TG_USERID_X,_UserId);
            serializeMessageProperty(b,TG_PASSWORD,TG_PASSWORD_X,_Password);
            serializeMessageProperty(b,TG_TIMESTAMP,TG_TIMESTAMP_X,_Timestamp);
            serializeMessageProperty(b,TG_TOPIC,TG_TOPIC_X,_Topic);
            serializeMessageProperty(b,TG_FILTER,TG_FILTER_X,_Filter);
            serializeMessageProperty(b,TG_ORDERBY,TG_ORDERBY_X,_OrderBy);
            serializeMessageProperty(b,TG_ACKTYPE,TG_ACKTYPE_X,_AckType);
            serializeMessageProperty(b,TG_OPTIONS,TG_OPTIONS_X,_Options);
            serializeMessageProperty(b,TG_SUBID,TG_SUBID_X,_SubId);
            serializeMessageProperty(b,TG_VERSION,TG_VERSION_X,_Version);
            serializeMessageProperty(b,TG_EXPIRATION,TG_EXPIRATION_X,_Expiration);
            serializeMessageProperty(b,TG_SENDMATCHINGIDS,TG_SENDMATCHINGIDS_X,_SendMatchingIds);
            serializeMessageProperty(b,TG_STATUS,TG_STATUS_X,_Status);
            serializeMessageProperty(b,TG_QUERYID,TG_QUERYID_X,_QueryId);
            serializeMessageProperty(b,TG_SENDOOF,TG_SENDOOF_X,_SendOOF);
            serializeMessageProperty(b,TG_SEQUENCE,TG_SEQUENCE_X,_Sequence);
            serializeMessageProperty(b,TG_BATCHSIZE,TG_BATCHSIZE_X,_BatchSize);
            serializeMessageProperty(b,TG_BOOKMARK,TG_BOOKMARK_X,_Bookmark);
            serializeMessageProperty(b,TG_TOPN,TG_TOPN_X,_TopN);
            serializeMessageProperty(b,TG_SENDEMPTIES,TG_SENDEMPTIES_X,_SendEmpties);
            serializeMessageProperty(b,TG_MAXMESSAGES,TG_MAXMESSAGES_X,_MaxMessages);
            serializeMessageProperty(b,TG_SOWKEYS,TG_SOWKEYS_X,_SowKeys);

            b.put(TG_XML_MESSAGE_MID);

            if(_Data.buffer != null)
            {
                b.put(_Data.buffer,_Data.position,_Data.length);
            }

            b.put(TG_XML_MESSAGE_EPILOG);

            //dumpBuffer("SENDING> ",b.array(),4,b.position()-4);
        }
        catch(BufferOverflowException e)
        {
            return SerializationResult.BufferTooSmall;
        }
        return SerializationResult.OK;
    }

    static private void dumpBuffer(String prefix,byte[] buffer,int start,int length)
    {
        System.err.print(prefix);
        for(int j = start; j < start+length; ++j)
        {
            try
            {
                System.err.print(new String(buffer,j,1,LATIN1));
            }
            catch(Exception e)
            {
                System.err.print("{error}");
            }
        }
        System.out.println();
    }
    
    public Message copy()
    {
        XMLMessage m = new XMLMessage(this.encoder, this.decoder);
        _copyTo(m);
        return m;
    }
}

