////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client;

import java.net.URI;
import java.beans.ExceptionListener;

import com.crankuptheamps.client.exception.AlreadyConnectedException;
import com.crankuptheamps.client.exception.ConnectionRefusedException;
import com.crankuptheamps.client.exception.DisconnectedException;
import com.crankuptheamps.client.exception.InvalidURIException;
import com.crankuptheamps.client.exception.RetryOperationException;

public interface Transport
{
    public void connect(URI uri)throws ConnectionRefusedException, AlreadyConnectedException, InvalidURIException;

    public void close();

    public void disconnect() ;

    public void setMessageHandler(MessageHandler ml);

    public void setDisconnectHandler(TransportDisconnectHandler dh);

    public void setExceptionListener(ExceptionListener exceptionListener);

    public void send(Message message) throws DisconnectedException;

    public void sendWithoutRetry(Message message) throws DisconnectedException;

    public Message allocateMessage();

    public long writeQueueSize() throws DisconnectedException;

    public long readQueueSize() throws DisconnectedException;

    public long flush() throws DisconnectedException;

    public long flush(long timeout) throws DisconnectedException;

    public void handleCloseEvent(int failedVersion_, String message, Exception e) throws DisconnectedException, RetryOperationException;
    
    public int getVersion();
    
    public void setReadTimeout(int readTimeoutMillis_);

    /**
     * Sets a TransportFilter that filters raw bytes before send and after receive.
     * @param filter_ A TransportFilter instance such as com.crankuptheamps.client.TransportTraceFilter.
     */
    public void setTransportFilter(TransportFilter filter_);
}

