////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////
package com.crankuptheamps.client;

/**
 * 
 * Interface for choosing amongst multiple instances for both initial connection
 * and reconnection. Used by {@link HAClient} to pick an initial server, and
 * then pick a new one on failure.
 * 
 */
public interface ServerChooser
{
    /**
     * Returns the current URI.
     * 
     * @return A string with the URI to connect to, or null if no server is
     *         available to connect to.
     */
    public String getCurrentURI();

    /**
     * Returns the Authenticator instance associated with the current URI.
     * 
     * @return An {@link Authenticator} or {@code null} if none is required for
     *         logon.
     */
    public Authenticator getCurrentAuthenticator() throws Exception;

    /**
     * Called by the {@link HAClient} when an error occurs connecting to the
     * current URI, and/or when an error occurs logging on. Implementors will
     * likely advance the current URI to the next one in a list, or choose to
     * stay with the current one, based on the exception type.
     * 
     * @param exception
     *            The exception associated with this failure.
     * @param info
     *            Information about the connection that failed.
     */
    public void reportFailure(Exception exception, ConnectionInfo info);

    /**
     * Provides additional detail to be included in an exception thrown when
     * the AMPS instance(s) are not available.  Called by the {@link HAClient}
     * when creating an exception.
     *
     * @return  An {@link String} with information about the connection
     *          that failed and the reason for the failure. When no
     *          further information is available, returns an empty string.
     */
    public String getError();


    /**
     * Called by the {@link HAClient} when successfully connected and logged on
     * to the current instance.
     * 
     * @param info
     *            Information about the successful connection.
     */
    public void reportSuccess(ConnectionInfo info);
    
    /**
     * Advances the server chooser to the next server it deems appropriate to connect with.
     */
    public void next();
    
}
