package com.crankuptheamps.client;

import java.io.IOException;
import java.nio.ByteBuffer;

import com.crankuptheamps.client.BlockPublishStore.ByteSequence;

public class MemoryStoreBuffer implements BlockPublishStore.Buffer
{

    protected ByteBuffer _buffer = null;
    protected PublishStoreResizeHandler _resizeHandler = null;
    protected Store _store = null;
    
    public long getSize() throws IOException
    {
        return _buffer==null?0:this._buffer.capacity();
        
    }

    public void setSize(long newSize) throws IOException
    {
        if (_resizeHandler != null && !_resizeHandler.invoke(_store, newSize))
            return;
        if(_buffer==null || newSize > this._buffer.capacity())
        {
            ByteBuffer b2 = ByteBuffer.allocate((int)newSize);
            if(_buffer != null) b2.put(_buffer.array());
            _buffer = b2;
        }
    }

    public long getPosition() throws IOException
    {
        return _buffer.position();
        
    }

    public void setPosition(long position) throws IOException
    {
        _buffer.position((int)position);        
    }

    public void putByte(byte b) throws IOException
    {
        _buffer.put(b);
    }


    public byte getByte() throws IOException
    {
        return _buffer.get();
    }

    public void putInt(int i) throws IOException
    {
        _buffer.putInt(i);
        
    }

    public int getInt() throws IOException
    {
        return _buffer.getInt();
    }

    public void putLong(long l) throws IOException
    {
        _buffer.putLong(l);
    }

    public long getLong() throws IOException
    {
        return _buffer.getLong();
    }

    public void putBytes(ByteSequence bytes) throws IOException
    {
        _buffer.put(bytes.array, (int)bytes.offset, (int)bytes.len);
    }

    public void getBytes(ByteSequence outBytes) throws IOException
    {
        if(_buffer.hasArray())
        {
            outBytes.array = _buffer.array();
            outBytes.offset = _buffer.position();
            _buffer.position((int)(outBytes.offset + outBytes.len));
        }
        else
        {
            outBytes.array = new byte[(int)outBytes.len];
            outBytes.offset = 0;
            _buffer.get(outBytes.array, 0, (int)outBytes.len);
        }
    }

    public void zero(long offset, int length) throws IOException
    {
       for(long i = 0; i < length; i+=8)
       {
           _buffer.putLong((int)offset + (int)i, 0);
       }
        
    }

    public void setResizeHandler(PublishStoreResizeHandler handler, Store store)
    {
        _resizeHandler = handler;
        _store = store;
    }
}
