////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client;

import java.nio.charset.*;
import java.util.Properties;

import com.crankuptheamps.client.exception.ProtocolException;

public class FIXProtocol implements Protocol
{

    public byte fieldSeparator          = 0x01;
    public byte headerSeparator         = 0x02;
    public byte messageSeparator        = 0x03;

    /**
     * The character set used to encode and decode messages sent via FIX.
     * If you wish to change this value (whose default is Latin-1), 
     * this value must be set before connecting a Client to a FIX endpoint.
     */
    public static String CharsetName = "ISO-8859-1";

    /**
     * Specifies the default action to be taken when a character cannot be
     * encoded or decoded.
     */
    public static CodingErrorAction CodingErrorAction = java.nio.charset.CodingErrorAction.REPORT;

    private boolean _isV1 = false;

    public FIXProtocol()
    {
    }

    public FIXProtocol(Properties props) throws ProtocolException
    {
        this.fieldSeparator = props.containsKey("fieldSeparator") ? (Byte)props.get("fieldSeparator") :(byte)1;
        this.headerSeparator = props.containsKey("headerSeparator")  ? (Byte) props.get("headerSeparator") :(byte)2;
        this.messageSeparator = props.containsKey("messageSeparator") ? (Byte) props.get("messageSeparator") :(byte)3;
    }

    public void setV1(boolean isV1)
    {
        _isV1 = isV1;
    }

    public FIXProtocol(byte fieldSeparator,
                          byte headerSeparator,
                          byte messageSeparator) throws ProtocolException
    {
        this.fieldSeparator = fieldSeparator;
        this.headerSeparator = headerSeparator;
        this.messageSeparator = messageSeparator;
    }

    public FIXMessage allocateMessage()
    {
        return new FIXMessage(this.fieldSeparator,
                              this.headerSeparator,
                              this.messageSeparator,
                              Charset.forName(CharsetName).newEncoder().onUnmappableCharacter(CodingErrorAction),
                              Charset.forName(CharsetName).newDecoder().onMalformedInput(CodingErrorAction),
                              _isV1);
    }

    public ProtocolParser getMessageStream()
    {
        return new FIXProtocolParser(this);
    }
}
