////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client;

import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

import com.crankuptheamps.client.fields.Field;

public class FIXMessage extends Message
{
    private static final String LATIN1       = "ISO-8859-1";
    private static final byte   LATIN1_ZERO  = 48;

    private static byte[] TG_COMMAND         = null;
    private static byte[] TG_COMMANDID       = null;
    private static byte[] TG_CLIENTNAME      = null;
    private static byte[] TG_USERID          = null;
    private static byte[] TG_PASSWORD        = null;
    private static byte[] TG_OPTIONS         = null;
    private static byte[] TG_TIMESTAMP       = null;
    private static byte[] TG_TOPIC           = null;
    private static byte[] TG_FILTER          = null;
    private static byte[] TG_ORDERBY         = null;
    private static byte[] TG_ACKTYPE         = null;
    private static byte[] TG_SUBID           = null;
    private static byte[] TG_VERSION         = null;
    private static byte[] TG_EXPIRATION      = null;
    private static byte[] TG_SENDMATCHINGIDS = null;
    private static byte[] TG_STATUS          = null;
    private static byte[] TG_QUERYID         = null;
    private static byte[] TG_SENDOOF         = null;
    private static byte[] TG_BATCHSIZE       = null;
    private static byte[] TG_BOOKMARK        = null;
    private static byte[] TG_CORRELATIONID   = null;
    private static byte[] TG_SEQUENCE        = null;
    private static byte[] TG_TOPN            = null;
    private static byte[] TG_SENDEMPTIES     = null;
    private static byte[] TG_MAXMESSAGES     = null;
    private static byte[] TG_SOWKEYS         = null;
    private static byte[] TG_V1FIX = null;

    static
    {
        try
        {
            TG_COMMAND         = "20000=".getBytes(LATIN1);
            TG_COMMANDID       = "20001=".getBytes(LATIN1);
            TG_CLIENTNAME      = "20002=".getBytes(LATIN1);
            TG_USERID          = "20003=".getBytes(LATIN1);
            TG_TIMESTAMP       = "20004=".getBytes(LATIN1);
            TG_TOPIC           = "20005=".getBytes(LATIN1);
            TG_FILTER          = "20006=".getBytes(LATIN1);
            TG_ORDERBY         = "20026=".getBytes(LATIN1);
            TG_ACKTYPE         = "20008=".getBytes(LATIN1);
            TG_SUBID           = "20009=".getBytes(LATIN1);
            TG_VERSION         = "20011=".getBytes(LATIN1);
            TG_EXPIRATION      = "20012=".getBytes(LATIN1);
            TG_SENDMATCHINGIDS = "20013=".getBytes(LATIN1);
            TG_STATUS          = "20018=".getBytes(LATIN1);
            TG_QUERYID         = "20019=".getBytes(LATIN1);
            TG_SENDOOF         = "20020=".getBytes(LATIN1);
            TG_BATCHSIZE       = "20023=".getBytes(LATIN1);
            TG_TOPN            = "20025=".getBytes(LATIN1);
            TG_SENDEMPTIES     = "20029=".getBytes(LATIN1);
            TG_MAXMESSAGES     = "20031=".getBytes(LATIN1);
            TG_SOWKEYS         = "20032=".getBytes(LATIN1);
            TG_CORRELATIONID   = "20035=".getBytes(LATIN1);
            TG_SEQUENCE        = "20036=".getBytes(LATIN1);
            TG_BOOKMARK        = "20037=".getBytes(LATIN1);
            TG_PASSWORD        = "20038=".getBytes(LATIN1);
            TG_OPTIONS         = "20039=".getBytes(LATIN1);
            TG_V1FIX           = "20007=fix".getBytes(LATIN1);
        }
        catch(UnsupportedEncodingException e)
        {
            //Absorb... these should never throw for ASCII
        }
    }

    public byte fieldSeparator;
    public byte headerSeparator;
    public byte messageSeparator;

    private boolean _v1Compat = false;

    public FIXMessage(byte fieldSeparator,
                      byte headerSeparator,
                      byte messageSeparator,
                      CharsetEncoder encoder,
                      CharsetDecoder decoder,
                      boolean isV1)
    {
        super(encoder, decoder);
        this.fieldSeparator   = fieldSeparator;
        this.headerSeparator  = headerSeparator;
        this.messageSeparator = messageSeparator;
        this._v1Compat = isV1;
    }

    final private void serializeMessageProperty(ByteBuffer b,
            byte[] tag,
            Field field)
    {
        if(field.buffer != null)
        {
            b.put(tag);
            b.put(field.buffer,field.position,field.length);
            b.put(fieldSeparator);
        }
    }

    SerializationResult serialize(ByteBuffer b)
    {
        try
        {
            if( this._v1Compat )
            {
                b.put(TG_V1FIX);
                b.put(fieldSeparator);
            }
            serializeMessageProperty(b,TG_COMMAND,_Command);
            serializeMessageProperty(b,TG_COMMANDID,_CommandId);
            serializeMessageProperty(b,TG_CLIENTNAME,_ClientName);
            serializeMessageProperty(b,TG_USERID,_UserId);
            serializeMessageProperty(b,TG_PASSWORD,_Password);
            serializeMessageProperty(b,TG_TIMESTAMP,_Timestamp);
            serializeMessageProperty(b,TG_TOPIC,_Topic);
            serializeMessageProperty(b,TG_FILTER,_Filter);
            serializeMessageProperty(b,TG_ORDERBY,_OrderBy);
            serializeMessageProperty(b,TG_ACKTYPE,_AckType);
            serializeMessageProperty(b,TG_OPTIONS,_Options);
            serializeMessageProperty(b,TG_SUBID,_SubId);
            serializeMessageProperty(b,TG_VERSION,_Version);
            serializeMessageProperty(b,TG_EXPIRATION,_Expiration);
            serializeMessageProperty(b,TG_SENDMATCHINGIDS,_SendMatchingIds);
            serializeMessageProperty(b,TG_STATUS,_Status);
            serializeMessageProperty(b,TG_QUERYID,_QueryId);
            serializeMessageProperty(b,TG_SENDOOF,_SendOOF);
            serializeMessageProperty(b,TG_BATCHSIZE,_BatchSize);
            serializeMessageProperty(b,TG_BOOKMARK,_Bookmark);
            serializeMessageProperty(b,TG_CORRELATIONID,_CorrelationId);
            serializeMessageProperty(b,TG_SEQUENCE,_Sequence);
            serializeMessageProperty(b,TG_TOPN,_TopN);
            serializeMessageProperty(b,TG_SENDEMPTIES,_SendEmpties);
            serializeMessageProperty(b,TG_MAXMESSAGES,_MaxMessages);
            serializeMessageProperty(b,TG_SOWKEYS,_SowKeys);

            b.put(headerSeparator);

            if(_Data.buffer != null)
            {
                b.put(_Data.buffer, _Data.position, _Data.length);
            }

            //dumpBuffer("SENDING> ",b.array(),4,b.position()-4);
        }
        catch (BufferOverflowException e)
        {
            return SerializationResult.BufferTooSmall;
        }
        return SerializationResult.OK;
    }

    void dumpBuffer(String prefix,byte[] buffer,int start,int length)
    {
        System.out.print(prefix);
        for(int j = 0; j < length; ++j)
        {
            byte c = buffer[start+j];
            if(c == fieldSeparator)
                System.out.print("{fs}");
            else if(c == headerSeparator)
                System.out.print("{hs}");
            else if(c == messageSeparator)
                System.out.print("{ms}");
            else
                try
                {
                    System.out.print(new String(buffer,start+j,1,LATIN1));
                }
                catch(Exception e)
                {
                    System.out.print("{error}");
                }
        }
        System.out.println();
    }
    
    public Message copy()
    {
        FIXMessage m = new FIXMessage(this.fieldSeparator, this.headerSeparator, this.messageSeparator, this.encoder, this.decoder, this._v1Compat);
        _copyTo(m);
        return m;
    }
}

