////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////
package com.crankuptheamps.client;

import com.crankuptheamps.client.exception.DisconnectedException;

/**
 * 
 * A simple ServerChooser that keeps a list of AMPS instances and
 * Authenticators, and advances to the next one when failure occurs.
 */
public class DefaultServerChooser implements ServerChooser
{
    String[] _uris;
    private static final int DEFAULT_SIZE = 5;
    int _currentFree, _current;

    public DefaultServerChooser()
    {
        _uris = new String[DEFAULT_SIZE];
        _currentFree = 0;
        _current = 0;
    }

    /**
     * Adds a URI to self.
     * 
     * @param uri
     *            The AMPS URI to add to the list.
     */
    public DefaultServerChooser add(String uri)
    {
        if (_currentFree >= _uris.length)
        {
            String[] newUris = new String[_uris.length * 2];
            System.arraycopy(_uris, 0, newUris, 0, _uris.length);
            _uris = newUris;
        }

        _uris[_currentFree] = uri;
        ++_currentFree;
        return this;
    }

    public String getCurrentURI()
    {
        if (_currentFree == 0)
        {
            return null;
        }
        if (_current >= _currentFree)
        {
            _current = 0;
        }
        return _uris[_current];
    }

    public Authenticator getCurrentAuthenticator()
    {
        return null;
    }

    public void reportFailure(Exception exception, ConnectionInfo info)
    {
        // In either case we'll just move on to the next
        // server whenever we have a failure connecting.
        // If we just got disconnected, though, we'll retry.
        if (!(exception instanceof DisconnectedException))
        {
            next();
        }
    }

    public void reportSuccess(ConnectionInfo info)
    {
        // This implementation does not use success.
    }

    public void next()
    {
        _current = (_current + 1) % _currentFree;
    }

    public String getError()
    {
        return "";
    }
}
