////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client;

import com.crankuptheamps.client.exception.*;

import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class CommandId
{
    public  byte[] id   = null;
    private int    hash = 0;
    static java.util.concurrent.atomic.AtomicLong _currentCommandId = new AtomicLong();
    
    public static CommandId nextIdentifier()
    {
        return new CommandId(String.format("%d", _currentCommandId.incrementAndGet()).getBytes());
    }

    CommandId()
    {
    }

    public CommandId(String string)
    {
        if(string != null)
        {
            this.id = string.getBytes();
            hash = Arrays.hashCode(id);
        }

    }

    CommandId(byte[] buffer)
    {
        this.id = buffer;
        hash = Arrays.hashCode(id);
    }

    CommandId(byte[] buffer, int position, int length)
    {
        this.id = new byte[length];
        System.arraycopy(buffer,position,id,0,length);
        hash = Arrays.hashCode(id);
    }

    public void set(byte[] buffer, int position, int length)
    {
        if(this.id == null || this.id.length != length) this.id = new byte[length];
        System.arraycopy(buffer,position,id,0,length);
        hash = Arrays.hashCode(this.id);
    }

    public boolean equals(Object obj)
    {
        return (obj instanceof CommandId
                && Arrays.equals(id,((CommandId)obj).id));
    }

    public int hashCode()
    {
        return hash;
    }

    public String toString()
    {
        return new String(id);
    }

}

