package com.crankuptheamps.examples;

import java.util.concurrent.CyclicBarrier;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.MessageHandler;
import com.crankuptheamps.client.fields.ReasonField;

import com.crankuptheamps.client.exception.AMPSException;

/**
 * Class to handle received messages. The class
 * implements an invoke(Message) method. That method
 * is called for each message received by the subscribe
 * command.
 *
 * @author 60East
 *
 */
public class BookmarkMessageHandler implements MessageHandler {

  private boolean sowfinished_ = false;
  private Client client_ = null; 
  private int maximum_ = 0;
  private int count_ = 0;
  
  /**
  * 
  * @param c The client to use to discard processed messages.
  *
  */
  BookmarkMessageHandler(Client c) {
     client_ = c;
  }

  /**
   * Method to wait until maximum results have been processed.
   *
   */
   public void waitUntilDone()
   {
      if (count_ >= maximum_) return;

      while (count_ < maximum_) { Thread.yield(); }
   }

  /**
   * Method for handling AMPS messages. This implementation
   * prints the message data to stdout.
   *
   * @param m the message to handle.
   */

  public void invoke(Message m) {

    if (count_ >= maximum_ && maximum_ != 0 ) return; // skip any incoming messages after max

    if (maximum_ > 0) count_++;  // 0 is unlimited

    try
    {

      if (m.getCommand() == Message.Command.OOF)
      {
        System.out.println("Message no longer in focus because : "
                           + ReasonField.encodeReason(m.getReason()) +
                           " : " + m.getData() );
        client_.getBookmarkStore().discard(m);
        return;
      }
      if (m.getCommand() == Message.Command.GroupBegin)
      {
        System.out.println("Receiving messages from SOW (beginning of group).");
        sowfinished_ = false;
        return;
      }
      if (m.getCommand() == Message.Command.GroupEnd)
      {
        System.out.println("Finished receiving messages from SOW (end of group).");
        sowfinished_ = true;
        return;
      }
      System.out.println(m.getData());
      client_.getBookmarkStore().discard(m);

      if (count_ > maximum_)
      {
        System.out.println("Reached maximum messages to process.");
      }

   }
   catch (AMPSException e)
   {
       System.err.println(e.getLocalizedMessage());
       e.printStackTrace(System.err);
   }

   
  }


  public boolean isSOWFinished() {
    return sowfinished_;
  }

  public int getMaximum()
  {
     return maximum_;
  }
  public void setMaximum(int maximum)
  {
     maximum_ = maximum;
  }


}
