/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.spark;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.ClientDisconnectHandler;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.MessageHandler;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.exception.ConnectionException;
import com.crankuptheamps.spark.CommandOption;
import com.crankuptheamps.spark.SparkCommand;
import java.util.UUID;

public class SubscribeCommand
extends SparkCommand {
    String uriString = null;
    String topic = null;
    String filter = null;

    public SubscribeCommand(String name) {
        super(name);
        this.addOption(new CommandOption("topic", "topic to query", true));
        this.addOption(new CommandOption("filter", "content filter to use", false));
        this.addOption(new CommandOption("delta", "use delta subscription", false));
        this.addOption(new CommandOption("bookmark", "begin subscription from bookmark", false));
        this.addOption(new CommandOption("limit", "limit number of mesasages received", false));
        this.addOption(new CommandOption("timeout", "timeout to wait for command to return in milliseconds", false));
        StringBuilder example = new StringBuilder(1024);
        example.append("  % ./spark subscribe -proto fix -server localhost:9003 -topic Trades -filter \"/55 = 'Transport.123'\"\n");
        example.append("    Connects to the AMPS instance listening on port 9003");
        example.append("    using the FIX protocol and prints incoming messages in topic 'Trades'");
        example.append("    that have tag 55 set to 'Transport.123'");
        this.addExample(example.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(String[] argv) {
        this.parseArgs(argv, 1);
        String[] userAndServer = ((CommandOption)this.options.get("server")).getValue().split("@", 2);
        String server = userAndServer.length == 2 ? userAndServer[1] : userAndServer[0];
        this.topic = ((CommandOption)this.options.get("topic")).getValue();
        String type = ((CommandOption)this.options.get("proto")).getValue();
        boolean delta = ((CommandOption)this.options.get("delta")).hasValue();
        int limit = 0;
        int timeout = 5000;
        if (((CommandOption)this.options.get("limit")).hasValue()) {
            limit = Integer.parseInt(((CommandOption)this.options.get("limit")).getValue());
        }
        if (!(type.equals("xml") || type.equals("fix") || type.equals("nvfix") || type.equals("amps") || type.equals("json"))) {
            this.badUsage("prot argument needs to be 'fix', 'xml', 'nvfix', 'amps', or 'json'.");
        }
        if (((CommandOption)this.options.get("filter")).hasValue()) {
            this.filter = ((CommandOption)this.options.get("filter")).getValue();
        }
        if (((CommandOption)this.options.get("timeout")).hasValue()) {
            timeout = Integer.parseInt(((CommandOption)this.options.get("timeout")).getValue());
        }
        String userId = userAndServer.length == 2 ? userAndServer[0] : System.getProperty("user.name");
        String clientName = "spark-subscribe-" + userId + "-" + UUID.randomUUID().toString();
        Client client = new Client(clientName, 131072);
        SubscribeCommandHandler handler = new SubscribeCommandHandler(limit, timeout);
        client.setDisconnectHandler(handler);
        try {
            this.uriString = "tcp://" + userId + "@" + server + "/" + type;
            client.connect(this.uriString);
            client.logon(5000L, this.createAuthenticator(this.uriString));
        }
        catch (ConnectionException e) {
            System.err.println("Unable to connect to AMPS (" + e + ").");
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Unable to connect to AMPS (" + e + ").");
            System.exit(1);
        }
        try {
            SubscribeCommandHandler e = handler;
            synchronized (e) {
                if (delta) {
                    client.deltaSubscribe(handler, this.topic, this.filter, timeout);
                } else if (((CommandOption)this.options.get("bookmark")).hasValue()) {
                    client.bookmarkSubscribe(handler, this.topic, this.filter, null, ((CommandOption)this.options.get("bookmark")).getValue(), Message.Options.None, timeout);
                } else {
                    client.subscribe(handler, this.topic, this.filter, timeout);
                }
                try {
                    handler.wait();
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error sending subscribe request: " + e.toString());
        }
        client.close();
    }

    private class SubscribeCommandHandler
    implements MessageHandler,
    ClientDisconnectHandler {
        int limit = 0;
        int current = 0;
        int timeout = 5000;

        public SubscribeCommandHandler(int limit, int timeout) {
            this.limit = limit;
            this.timeout = timeout;
        }

        public void invoke(Message message) {
            System.out.println(message.getData());
            if (this.limit > 0 && ++this.current >= this.limit) {
                System.exit(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(Client client) {
            int attempts = 0;
            while (++attempts <= 5) {
                try {
                    System.err.println("DISCONNECTED, trying to reconnect (attempt #" + attempts + ")");
                    client.connect(SubscribeCommand.this.uriString);
                    client.logon(5000L, SubscribeCommand.this.createAuthenticator(SubscribeCommand.this.uriString));
                    client.subscribe(this, SubscribeCommand.this.topic, SubscribeCommand.this.filter, this.timeout);
                    return;
                }
                catch (AMPSException e) {
                    System.err.println("Unable to re-connect to AMPS (" + e + ").");
                    client.disconnect();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            System.err.println("Unable to reestablish connection to AMPS.");
            SubscribeCommandHandler subscribeCommandHandler = this;
            synchronized (subscribeCommandHandler) {
                this.notifyAll();
            }
        }
    }
}

