/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.spark;

import com.crankuptheamps.spark.HelpCommand;
import com.crankuptheamps.spark.PingCommand;
import com.crankuptheamps.spark.PublishCommand;
import com.crankuptheamps.spark.SOWAndSubscribeCommand;
import com.crankuptheamps.spark.SOWCommand;
import com.crankuptheamps.spark.SOWDeleteCommand;
import com.crankuptheamps.spark.SparkCommand;
import com.crankuptheamps.spark.SubscribeCommand;
import java.util.TreeMap;

public class Spark {
    private static TreeMap<String, SparkCommand> commands = new TreeMap();

    private static void loadCommands() {
        commands.put("sow", new SOWCommand("sow"));
        commands.put("ping", new PingCommand("ping"));
        commands.put("publish", new PublishCommand("publish"));
        commands.put("subscribe", new SubscribeCommand("subscribe"));
        commands.put("sow_and_subscribe", new SOWAndSubscribeCommand("sow_and_subscribe"));
        commands.put("sow_delete", new SOWDeleteCommand("sow_delete"));
        commands.put("help", new HelpCommand("help", commands));
    }

    public static void main(String[] args) throws Exception {
        String command;
        Spark.loadCommands();
        if (args.length < 1) {
            commands.get("help").help();
            System.exit(0);
        }
        if (!commands.containsKey(command = args[0])) {
            commands.get("help").help();
            System.err.println("Error: command '" + command + "' is not valid.");
            System.exit(1);
        }
        commands.get(command).execute(args);
        System.exit(0);
    }
}

