/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.spark;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.ClientDisconnectHandler;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.exception.ConnectionException;
import com.crankuptheamps.spark.CommandOption;
import com.crankuptheamps.spark.SparkCommand;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import java.util.UUID;

public class PublishCommand
extends SparkCommand {
    private int messageCount = 0;
    private String uriString = null;
    private static final String LATIN1 = "ISO-8859-1";

    public PublishCommand(String name) {
        super(name);
        this.addOption(new CommandOption("topic", "topic to publish to", true));
        this.addOption(new CommandOption("file", "file to publish records from, standard in when omitted", false));
        this.addOption(new CommandOption("delta", "use delta publish", false));
        this.addOption(new CommandOption("delimiter", "decimal value of message separator character (default 10)", false));
        this.addOption(new CommandOption("rate", "decimal value used to send messages\n\t\tat a fixed rate.  '.25' implies 1 message every 4 seconds.\n\t\t'1000' implies 1000 messages per second.", false));
        StringBuilder example = new StringBuilder(1024);
        example.append("  % ./spark publish -server localhost:9003 -topic Trades -file data.fix \n\n");
        example.append("    Connects to the AMPS instance listening on port 9003 and publishes records\n");
        example.append("    found in the 'data.fix' file to topic 'Trades'.");
        this.addExample(example.toString());
    }

    void execute(String[] argv) {
        this.parseArgs(argv, 1);
        String[] userAndServer = ((CommandOption)this.options.get("server")).getValue().split("@", 2);
        String server = userAndServer.length == 2 ? userAndServer[1] : userAndServer[0];
        String topic = ((CommandOption)this.options.get("topic")).getValue();
        String type = ((CommandOption)this.options.get("proto")).getValue();
        String delimiter = ((CommandOption)this.options.get("delimiter")).getValue();
        boolean delta = ((CommandOption)this.options.get("delta")).hasValue();
        String fileName = null;
        long nano_interval = 0L;
        if (!(type.equals("xml") || type.equals("fix") || type.equals("nvfix") || type.equals("amps") || type.equals("json"))) {
            this.badUsage("prot argument needs to be 'fix', 'xml', 'nvfix', 'amps', or 'json'.");
        }
        if (((CommandOption)this.options.get("file")).hasValue()) {
            fileName = ((CommandOption)this.options.get("file")).getValue();
        }
        if (((CommandOption)this.options.get("rate")).hasValue()) {
            nano_interval = Math.round(1.0 / Double.valueOf(((CommandOption)this.options.get("rate")).getValue()) * Math.pow(10.0, 9.0));
        }
        String userId = userAndServer.length == 2 ? userAndServer[0] : System.getProperty("user.name");
        String clientName = "spark-publish-" + userId + "-" + UUID.randomUUID().toString();
        Client client = new Client(clientName, 131072);
        client.setDisconnectHandler(new SparkDisconnectHandler());
        try {
            this.uriString = "tcp://" + userId + "@" + server + "/" + type;
            client.connect(this.uriString);
            client.logon(5000L, this.createAuthenticator(this.uriString));
        }
        catch (ConnectionException e) {
            System.err.println("Unable to connect to AMPS (" + e + ").");
            System.exit(1);
        }
        long start = 0L;
        try {
            String line = "";
            Scanner scanner = fileName != null ? new Scanner(new File(fileName), LATIN1) : new Scanner(System.in);
            start = System.currentTimeMillis();
            try {
                Message message = client.allocateMessage();
                if (delta) {
                    message.setCommand(64);
                } else {
                    message.setCommand(1);
                }
                message.setTopic(topic);
                if (delimiter != null) {
                    try {
                        String strDelim = Character.toString((char)Integer.parseInt(delimiter));
                        scanner.useDelimiter(strDelim);
                    }
                    catch (NumberFormatException nfex) {
                        System.err.println("Delimiter is not a valid integer");
                        System.exit(1);
                    }
                } else {
                    scanner.useDelimiter(System.getProperty("line.separator"));
                }
                long nextPubTime = System.nanoTime();
                while (scanner.hasNext()) {
                    line = scanner.next();
                    message.setData(line);
                    while (nextPubTime > System.nanoTime()) {
                    }
                    nextPubTime += nano_interval;
                    client.send(message);
                    ++this.messageCount;
                }
            }
            catch (AMPSException e) {
                System.err.format("Error: disconnected (total messages published: %d) [%s]\n", this.messageCount, e);
                System.exit(1);
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            this.badUsage("file '" + fileName + "' not found");
        }
        client.close();
        long elapsed = System.currentTimeMillis() - start;
        System.err.format("total messages published: %d (%.2f/s)\n", this.messageCount, 1000.0 * (double)this.messageCount / (double)elapsed);
    }

    private class SparkDisconnectHandler
    implements ClientDisconnectHandler {
        private SparkDisconnectHandler() {
        }

        public void invoke(Client client) {
            System.err.format("DISCONNECTED, trying to reconnect...%n", new Object[0]);
            try {
                client.connect(PublishCommand.this.uriString);
                client.logon(5000L, PublishCommand.this.createAuthenticator(PublishCommand.this.uriString));
            }
            catch (AMPSException e) {
                System.err.println("Unable to re-connect to AMPS (" + e + ").");
                System.exit(1);
            }
        }
    }
}

