/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.spark;

import com.crankuptheamps.spark.SparkCommand;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpCommand
extends SparkCommand {
    private TreeMap<String, SparkCommand> commands = null;

    public HelpCommand(String name, TreeMap<String, SparkCommand> commands) {
        super(name);
        this.commands = commands;
        this.options.clear();
        this.required.clear();
        this.optional.clear();
        StringBuilder example = new StringBuilder(1024);
        example.append("  % ./spark help sow\n");
        example.append("  Returns the help and usage information for the 'sow' command.\n");
        this.addExample(example.toString());
        StringBuilder extra = new StringBuilder(1024);
        extra.append("Supported Commands:\n");
        extra.append("\n");
        extra.append("  help\n");
        for (String commandName : commands.keySet()) {
            extra.append("  " + commandName + "\n");
        }
        this.addExtra(extra.toString());
        this.setUsage("spark help [command]");
    }

    @Override
    void execute(String[] argv) {
        if (argv.length < 2) {
            this.help();
        } else {
            String command = argv[1];
            if (this.commands.containsKey(command)) {
                this.commands.get(command).help();
            } else {
                System.err.println("Error: command '" + command + "' not found.");
                System.exit(1);
            }
        }
    }
}

