/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.TransportFilter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;

public class TransportTraceFilter
implements TransportFilter {
    PrintStream _stream;
    byte[] _temporaryBuffer;

    public TransportTraceFilter(OutputStream stream_) {
        this._stream = new PrintStream(stream_);
    }

    protected void print(String prefix, ByteBuffer data) {
        this._stream.print(prefix);
        if (data.hasArray()) {
            this._stream.write(data.array(), 0, data.limit());
            this._stream.println();
        } else {
            int length = data.limit();
            int position = data.position();
            if (this._temporaryBuffer == null || this._temporaryBuffer.length <= length) {
                this._temporaryBuffer = new byte[length];
            }
            data.get(this._temporaryBuffer, 0, length);
            data.position(position);
            this._stream.write(this._temporaryBuffer, 0, length);
            this._stream.println();
        }
    }

    public void outgoing(ByteBuffer data) {
        this.print("OUTGOING ===> ", data);
    }

    public void incoming(ByteBuffer data) {
        this.print("INCOMING ===> ", data);
    }
}

