/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.BlockPublishStore;
import com.crankuptheamps.client.MemoryStoreBuffer;
import com.crankuptheamps.client.PublishStoreResizeHandler;
import com.crankuptheamps.client.Store;
import com.crankuptheamps.client.exception.StoreException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class PublishStore
extends BlockPublishStore {
    static final int DEFAULT_INITIAL_BLOCKS = 10000;

    public PublishStore(String path) throws StoreException {
        this(path, 10000);
    }

    public PublishStore(String path, int initialCapacity) throws StoreException {
        super(new MMapStoreBuffer(path), initialCapacity);
        this.recover();
        if (this._usedList == null) {
            this.growFreeListIfEmpty();
        }
    }

    public void close() throws IOException {
        ((MMapStoreBuffer)this._buffer).close();
    }

    public void sync() throws IOException {
        ((MMapStoreBuffer)this._buffer).sync();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    static class MMapStoreBuffer
    extends MemoryStoreBuffer {
        String _path;
        RandomAccessFile _file;
        FileChannel _channel;
        Store _store;

        public MMapStoreBuffer(String path) throws StoreException {
            this._path = path;
            try {
                this._file = new RandomAccessFile(path, "rw");
            }
            catch (IOException e) {
                throw new StoreException(e);
            }
            this._channel = this._file.getChannel();
        }

        public long getSize() throws IOException {
            if (this._buffer == null) {
                if (this._file.length() == 0L) {
                    return 0L;
                }
                this._buffer = this._channel.map(FileChannel.MapMode.READ_WRITE, 0L, this._file.length());
            }
            return this._buffer.capacity();
        }

        public void setSize(long newSize) throws IOException {
            if (this._channel == null) {
                throw new IOException("The store is closed.");
            }
            if (this._buffer != null) {
                ((MappedByteBuffer)this._buffer).force();
            }
            if (this._resizeHandler != null && !this._resizeHandler.invoke(this._store, newSize)) {
                return;
            }
            this._buffer = this._channel.map(FileChannel.MapMode.READ_WRITE, 0L, newSize);
        }

        public void close() throws IOException {
            this._buffer = null;
            this._channel.close();
            this._file.close();
        }

        public void sync() throws IOException {
            MappedByteBuffer b = (MappedByteBuffer)this._buffer;
            b.force();
        }

        public void setResizeHandler(PublishStoreResizeHandler handler, Store store) {
            this._resizeHandler = handler;
            this._store = store;
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

