/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.Subscription;
import com.crankuptheamps.client.exception.CommandException;
import com.crankuptheamps.client.fields.AckTypeField;
import com.crankuptheamps.client.fields.BookmarkField;
import com.crankuptheamps.client.fields.BooleanField;
import com.crankuptheamps.client.fields.CommandField;
import com.crankuptheamps.client.fields.Field;
import com.crankuptheamps.client.fields.IntegerField;
import com.crankuptheamps.client.fields.LongField;
import com.crankuptheamps.client.fields.ReasonField;
import com.crankuptheamps.client.fields.StatusField;
import com.crankuptheamps.client.fields.StringField;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public abstract class Message {
    protected final CharsetEncoder encoder;
    protected final CharsetDecoder decoder;
    protected static final int MINIMUM_SERVER_VERSION = 4000000;
    long _bookmarkSeqNo = 0L;
    Subscription _subscription = null;
    private byte[] buffer = null;
    private int _rawBufferOffset = 0;
    private int _rawBufferLength = 0;
    AckTypeField _AckType = new AckTypeField();
    IntegerField _BatchSize = new IntegerField();
    BookmarkField _Bookmark = new BookmarkField();
    StringField _ClientName = new StringField();
    StringField _CommandId = new StringField();
    CommandField _Command = new CommandField();
    StringField _Data = new StringField();
    IntegerField _Expiration = new IntegerField();
    StringField _Filter = new StringField();
    StringField _OrderBy = new StringField();
    LongField _GroupSeqNo = new LongField();
    LongField _Matches = new LongField();
    LongField _MaxMessages = new LongField();
    StringField _MessageId = new StringField();
    StringField _Password = new StringField();
    IntegerField _Length = new IntegerField();
    StringField _Options = new StringField();
    StringField _QueryId = new StringField();
    ReasonField _Reason = new ReasonField();
    LongField _RecordsInserted = new LongField();
    LongField _RecordsUpdated = new LongField();
    LongField _RecordsDeleted = new LongField();
    LongField _RecordsReturned = new LongField();
    BooleanField _SendEmpties = new BooleanField();
    BooleanField _SendMatchingIds = new BooleanField();
    BooleanField _SendOOF = new BooleanField();
    LongField _Sequence = new LongField();
    StringField _SowKey = new StringField();
    StringField _SowKeys = new StringField();
    StatusField _Status = new StatusField();
    StringField _SubId = new StringField();
    StringField _SubIds = new StringField();
    StringField _Timestamp = new StringField();
    LongField _TopN = new LongField();
    StringField _Topic = new StringField();
    LongField _TopicMatches = new LongField();
    StringField _UserId = new StringField();
    StringField _Version = new StringField();
    StringField _CorrelationId = new StringField();

    public Message(CharsetEncoder encoder, CharsetDecoder decoder) {
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public void setBookmarkSeqNo(long val) {
        this._bookmarkSeqNo = val;
    }

    public long getBookmarkSeqNo() {
        return this._bookmarkSeqNo;
    }

    public void setSubscription(Subscription subscription) {
        this._subscription = subscription;
    }

    public Subscription getSubscription() {
        return this._subscription;
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setRawBufferOffset(int offset) {
        this._rawBufferOffset = offset;
    }

    public int getRawBufferOffset() {
        return this._rawBufferOffset;
    }

    public void setRawBufferLength(int length) {
        this._rawBufferLength = length;
    }

    public int getRawBufferLength() {
        return this._rawBufferLength;
    }

    abstract SerializationResult serialize(ByteBuffer var1);

    public void reset() {
        this._AckType.reset();
        this._BatchSize.reset();
        this._Bookmark.reset();
        this._ClientName.reset();
        this._CommandId.reset();
        this._Command.reset();
        this._CorrelationId.reset();
        this._Data.reset();
        this._Expiration.reset();
        this._Filter.reset();
        this._OrderBy.reset();
        this._GroupSeqNo.reset();
        this._Length.reset();
        this._Matches.reset();
        this._MaxMessages.reset();
        this._MessageId.reset();
        this._Options.reset();
        this._QueryId.reset();
        this._Reason.reset();
        this._RecordsInserted.reset();
        this._RecordsUpdated.reset();
        this._RecordsDeleted.reset();
        this._RecordsReturned.reset();
        this._SendEmpties.reset();
        this._SendMatchingIds.reset();
        this._SendOOF.reset();
        this._Sequence.reset();
        this._SowKey.reset();
        this._SowKeys.reset();
        this._Status.reset();
        this._SubId.reset();
        this._SubIds.reset();
        this._Timestamp.reset();
        this._TopN.reset();
        this._Topic.reset();
        this._TopicMatches.reset();
        this._UserId.reset();
        this._Version.reset();
        this._Password.reset();
        this._bookmarkSeqNo = 0L;
        this._subscription = null;
    }

    public int getAckType() {
        return this._AckType.getValue();
    }

    public void setAckType(int v) {
        this._AckType.setValue(v);
    }

    public void setAckType(String v) {
        this._AckType.set(v.getBytes());
    }

    public int getBatchSize() {
        return this._BatchSize.getValue();
    }

    public void setBatchSize(int v) {
        this._BatchSize.setValue(v);
    }

    public String getBookmark() {
        return this._Bookmark.getValue(this.decoder);
    }

    public BookmarkField getBookmarkRaw() {
        return this._Bookmark;
    }

    public void setBookmark(String v) {
        this._Bookmark.setValue(v, this.encoder);
    }

    public void setBookmark(byte[] buffer, int offset, int length) {
        this._Bookmark.setValue(buffer, offset, length);
    }

    public String getClientName() {
        return this._ClientName.getValue(this.decoder);
    }

    public Field getClientNameRaw() {
        return this._ClientName;
    }

    public void setClientName(String v) {
        this._ClientName.setValue(v, this.encoder);
    }

    public void setClientName(byte[] buffer, int offset, int length) {
        this._ClientName.setValue(buffer, offset, length);
    }

    public String getCommandId() {
        return this._CommandId.getValue(this.decoder);
    }

    public Field getCommandIdRaw() {
        return this._CommandId;
    }

    public boolean getCommandId(CommandId v) {
        return this._CommandId.getValue(v);
    }

    public void setCommandId(String v) {
        this._CommandId.setValue(v, this.encoder);
    }

    public void setCommandId(CommandId v) {
        this._CommandId.setValue(v);
    }

    public void setCommandId(byte[] buffer, int offset, int length) {
        this._CommandId.setValue(buffer, offset, length);
    }

    public int getCommand() {
        return this._Command.getValue();
    }

    public void setCommand(int v) {
        this._Command.setValue(v);
    }

    public void setCommand(String v) {
        this._Command.set(v.getBytes());
    }

    public String getData() {
        return this._Data.getValue(this.decoder);
    }

    public Field getDataRaw() {
        return this._Data;
    }

    public void setData(String v) {
        this._Data.setValue(v, this.encoder);
    }

    public void setData(byte[] buffer, int offset, int length) {
        this._Data.setValue(buffer, offset, length);
    }

    public int getExpiration() {
        return this._Expiration.getValue();
    }

    public void setExpiration(int v) {
        this._Expiration.setValue(v);
    }

    public String getFilter() {
        return this._Filter.getValue(this.decoder);
    }

    public Field getFilterRaw() {
        return this._Filter;
    }

    public void setFilter(String v) {
        this._Filter.setValue(v, this.encoder);
    }

    public void setFilter(byte[] buffer, int offset, int length) {
        this._Filter.setValue(buffer, offset, length);
    }

    public String getOrderBy() {
        return this._OrderBy.getValue(this.decoder);
    }

    public Field getOrderByRaw() {
        return this._OrderBy;
    }

    public void setOrderBy(String v) {
        this._OrderBy.setValue(v, this.encoder);
    }

    public void setOrderBy(byte[] buffer, int offset, int length) {
        this._OrderBy.setValue(buffer, offset, length);
    }

    public long getGroupSeqNo() {
        return this._GroupSeqNo.getValue();
    }

    public void setGroupSeqNo(long v) {
        this._GroupSeqNo.setValue(v);
    }

    public long getMatches() {
        return this._Matches.getValue();
    }

    public void setMatches(long v) {
        this._Matches.setValue(v);
    }

    public long getMaxMessages() {
        return this._MaxMessages.getValue();
    }

    public void setMaxMessages(long v) {
        this._MaxMessages.setValue(v);
    }

    public String getMessageId() {
        return this._MessageId.getValue(this.decoder);
    }

    public Field getMessageIdRaw() {
        return this._MessageId;
    }

    public void setMessageId(String v) {
        this._MessageId.setValue(v, this.encoder);
    }

    public void setMessageId(byte[] buffer, int offset, int position) {
        this._MessageId.setValue(buffer, offset, position);
    }

    public String getPassword() {
        return this._Password.getValue(this.decoder);
    }

    public Field getPasswordRaw() {
        return this._Password;
    }

    public void setPassword(String v) {
        this._Password.setValue(v, this.encoder);
    }

    public void setPassword(byte[] buffer, int offset, int length) {
        this._Password.setValue(buffer, offset, length);
    }

    public int getLength() {
        return this._Length.getValue();
    }

    public void setLength(int v) {
        this._Length.setValue(v);
    }

    public String getOptions() {
        return this._Options.getValue(this.decoder);
    }

    public void setOptions(String v) {
        this._Options.setValue(v, this.encoder);
    }

    public String getQueryId() {
        return this._QueryId.getValue(this.decoder);
    }

    public Field getQueryIdRaw() {
        return this._QueryId;
    }

    public boolean getQueryId(CommandId v) {
        return this._QueryId.getValue(v);
    }

    public void setQueryId(String v) {
        this._QueryId.setValue(v, this.encoder);
    }

    public void setQueryId(CommandId v) {
        this._QueryId.setValue(v);
    }

    public void setQueryId(byte[] buffer, int offset, int position) {
        this._QueryId.setValue(buffer, offset, position);
    }

    public int getReason() {
        return this._Reason.getValue();
    }

    public String getReasonText() {
        return this._Reason.getText();
    }

    public void setReason(int v) {
        this._Reason.setValue(v);
    }

    public long getRecordsInserted() {
        return this._RecordsInserted.getValue();
    }

    public void setRecordsInserted(long v) {
        this._RecordsInserted.setValue(v);
    }

    public long getRecordsUpdated() {
        return this._RecordsUpdated.getValue();
    }

    public void setRecordsUpdated(long v) {
        this._RecordsUpdated.setValue(v);
    }

    public long getRecordsDeleted() {
        return this._RecordsDeleted.getValue();
    }

    public void setRecordsDeleted(long v) {
        this._RecordsDeleted.setValue(v);
    }

    public long getRecordsReturned() {
        return this._RecordsReturned.getValue();
    }

    public void setRecordsReturned(long v) {
        this._RecordsReturned.setValue(v);
    }

    public boolean getSendEmpties() {
        return this._SendEmpties.getValue();
    }

    public void setSendEmpties(boolean v) {
        this._SendEmpties.setValue(v);
    }

    public boolean getSendMatchingIds() {
        return this._SendMatchingIds.getValue();
    }

    public void setSendMatchingIds(boolean v) {
        this._SendMatchingIds.setValue(v);
    }

    public boolean getSendOOF() {
        return this._SendOOF.getValue();
    }

    public void setSendOOF(boolean v) {
        this._SendOOF.setValue(v);
    }

    public Field getSequenceRaw() {
        return this._Sequence;
    }

    public long getSequence() {
        return this._Sequence.getValue();
    }

    public void setSequence(long v) {
        this._Sequence.setValue(v);
    }

    public String getSowKey() {
        return this._SowKey.getValue(this.decoder);
    }

    public Field getSowKeyRaw() {
        return this._SowKey;
    }

    public void setSowKey(String v) {
        this._SowKey.setValue(v, this.encoder);
    }

    public void setSowKey(byte[] buffer, int offset, int length) {
        this._SowKey.setValue(buffer, offset, length);
    }

    public String getSowKeys() {
        return this._SowKeys.getValue(this.decoder);
    }

    public Field getSowKeysRaw() {
        return this._SowKeys;
    }

    public void setSowKeys(String v) {
        this._SowKeys.setValue(v, this.encoder);
    }

    public void setSowKeys(byte[] buffer, int offset, int length) {
        this._SowKeys.setValue(buffer, offset, length);
    }

    public int getStatus() {
        return this._Status.getValue();
    }

    public void setStatus(int v) {
        this._Status.setValue(v);
    }

    public String getSubId() {
        return this._SubId.getValue(this.decoder);
    }

    public Field getSubIdRaw() {
        return this._SubId;
    }

    public boolean getSubId(CommandId v) {
        return this._SubId.getValue(v);
    }

    public void setSubId(String v) {
        this._SubId.setValue(v, this.encoder);
    }

    public void setSubId(CommandId v) {
        this._SubId.setValue(v);
    }

    public void setSubId(byte[] buffer, int offset, int length) {
        this._SubId.setValue(buffer, offset, length);
    }

    public String getSubIds() {
        return this._SubIds.getValue(this.decoder);
    }

    public Field getSubIdsRaw() {
        return this._SubIds;
    }

    public void setSubIds(String v) {
        this._SubIds.setValue(v, this.encoder);
    }

    public void setSubIds(byte[] buffer, int offset, int length) {
        this._SubIds.setValue(buffer, offset, length);
    }

    public String getTimestamp() {
        return this._Timestamp.getValue(this.decoder);
    }

    public Field getTimestampRaw() {
        return this._Timestamp;
    }

    public void setTimestamp(String v) {
        this._Timestamp.setValue(v, this.encoder);
    }

    public void setTimestamp(byte[] buffer, int offset, int length) {
        this._Timestamp.setValue(buffer, offset, length);
    }

    public long getTopN() {
        return this._TopN.getValue();
    }

    public void setTopN(long v) {
        this._TopN.setValue(v);
    }

    public String getTopic() {
        return this._Topic.getValue(this.decoder);
    }

    public Field getTopicRaw() {
        return this._Topic;
    }

    public void setTopic(String v) {
        this._Topic.setValue(v, this.encoder);
    }

    public void setTopic(byte[] buffer, int offset, int length) {
        this._Topic.setValue(buffer, offset, length);
    }

    public long getTopicMatches() {
        return this._TopicMatches.getValue();
    }

    public void setTopicMatches(long v) {
        this._TopicMatches.setValue(v);
    }

    public String getUserId() {
        return this._UserId.getValue(this.decoder);
    }

    public Field getUserIdRaw() {
        return this._UserId;
    }

    public void setUserId(String v) {
        this._UserId.setValue(v, this.encoder);
    }

    public void setUserId(byte[] buffer, int offset, int length) {
        this._UserId.setValue(buffer, offset, length);
    }

    public String getVersion() {
        return this._Version.getValue(this.decoder);
    }

    public Field getVersionRaw() {
        return this._Version;
    }

    public int getVersionAsInt() {
        if (this._Version.isNull()) {
            return 0;
        }
        int version = 0;
        try {
            version = Client.getVersionAsInt(this._Version.getValue(this.decoder));
        }
        catch (CommandException commandException) {
            // empty catch block
        }
        if (version == 0) {
            version = 4000000;
        }
        return version;
    }

    public void setVersion(String v) {
        this._Version.setValue(v, this.encoder);
    }

    public void setVersion(byte[] buffer, int offset, int length) {
        this._Version.setValue(buffer, offset, length);
    }

    public void setCorrelationId(String v) {
        this._CorrelationId.setValue(v, this.encoder);
    }

    public String getCorrelationId() {
        return this._CorrelationId.getValue(this.decoder);
    }

    public StringField getCorrelationIdRaw() {
        return this._CorrelationId;
    }

    public String toString() {
        String tmp = "";
        StringBuilder s = new StringBuilder(1024);
        s.append("Message{");
        s.append("Command=").append(CommandField.encodeCommand(this.getCommand())).append("; ");
        try {
            tmp = "AckType=" + this._AckType.toString();
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            tmp = "BatchSize=" + this.getBatchSize();
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (this.getClientName() != null) {
            s.append("ClientName=").append(this.getClientName()).append("; ");
        }
        if (this.getCommandId() != null) {
            s.append("CommandId=").append(this.getCommandId()).append("; ");
        }
        try {
            tmp = "Expiration=" + this.getExpiration();
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (this.getFilter() != null) {
            s.append("Filter=").append(this.getFilter()).append("; ");
        }
        if (this.getOrderBy() != null) {
            s.append("OrderBy=").append(this.getOrderBy()).append("; ");
        }
        try {
            tmp = "GroupSeqNo=" + Long.toString(this.getGroupSeqNo());
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            tmp = "Matches=" + Long.toString(this.getMatches());
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            tmp = "MaxMessages=" + Long.toString(this.getMaxMessages());
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (this.getMessageId() != null) {
            s.append("MessageId=").append(this.getMessageId()).append("; ");
        }
        try {
            tmp = "Length=" + Integer.toString(this.getLength());
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            tmp = "Options=" + this.getOptions();
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (this.getPassword() != null) {
            s.append("Password=").append(this.getPassword()).append("; ");
        }
        if (this.getQueryId() != null) {
            s.append("QueryId=").append(this.getQueryId()).append("; ");
        }
        try {
            tmp = "Reason=" + ReasonField.encodeReason(this.getReason());
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            tmp = "RecordsUpdated=" + Long.toString(this.getRecordsUpdated());
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            tmp = "RecordsInserted=" + Long.toString(this.getRecordsInserted());
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            tmp = "RecordsReturned=" + Long.toString(this.getRecordsReturned());
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            tmp = "RecordsDeleted=" + Long.toString(this.getRecordsDeleted());
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            tmp = "SendEmpties=" + (this.getSendEmpties() ? "true" : "false");
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            tmp = "SendMatchingIds=" + (this.getSendMatchingIds() ? "true" : "false");
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            tmp = "SendOOF=" + (this.getSendOOF() ? "true" : "false");
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (this.getSowKey() != null) {
            s.append("SowKey=").append(this.getSowKey()).append("; ");
        }
        if (this.getSowKeys() != null) {
            s.append("SowKeys=").append(this.getSowKeys()).append("; ");
        }
        try {
            tmp = "Status=" + StatusField.encodeStatus(this.getStatus());
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (this.getSubId() != null) {
            s.append("SubId=").append(this.getSubId()).append("; ");
        }
        if (this.getSubIds() != null) {
            s.append("SubIds=").append(this.getSubIds()).append("; ");
        }
        if (this.getTimestamp() != null) {
            s.append("Timestamp=").append(this.getTimestamp()).append("; ");
        }
        try {
            tmp = "TopN=" + Long.toString(this.getTopN());
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (this.getTopic() != null) {
            s.append("Topic=").append(this.getTopic()).append("; ");
        }
        try {
            tmp = "TopicMatches=" + Long.toString(this.getTopicMatches());
            s.append(tmp + "; ");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        String correlationId = this.getCorrelationId();
        if (correlationId != null) {
            s.append("CorrelationId=").append(correlationId).append("; ");
        }
        if (this.getUserId() != null) {
            s.append("UserId=").append(this.getUserId().toString()).append("; ");
        }
        if (this.getData() != null) {
            s.append("Data=").append(this.getData()).append("; ");
        }
        s.append("}");
        return s.toString();
    }

    public abstract Message copy();

    protected void _copyTo(Message destination) {
        destination.buffer = new byte[this.buffer.length];
        destination._rawBufferLength = this._rawBufferLength;
        destination._rawBufferOffset = this._rawBufferOffset;
        System.arraycopy(this.buffer, 0, destination.buffer, 0, this.buffer.length);
        destination._AckType.set(destination.buffer, this._AckType.position, this._AckType.length);
        destination._BatchSize.set(destination.buffer, this._BatchSize.position, this._BatchSize.length);
        destination._Bookmark.set(destination.buffer, this._Bookmark.position, this._Bookmark.length);
        destination._ClientName.set(destination.buffer, this._ClientName.position, this._ClientName.length);
        destination._Command.set(destination.buffer, this._Command.position, this._Command.length);
        destination._CommandId.set(destination.buffer, this._CommandId.position, this._CommandId.length);
        destination._CorrelationId.set(destination.buffer, this._CorrelationId.position, this._CorrelationId.length);
        destination._Data.set(destination.buffer, this._Data.position, this._Data.length);
        destination._Expiration.set(destination.buffer, this._Expiration.position, this._Expiration.length);
        destination._Filter.set(destination.buffer, this._Filter.position, this._Filter.length);
        destination._GroupSeqNo.set(destination.buffer, this._GroupSeqNo.position, this._GroupSeqNo.length);
        destination._Length.set(destination.buffer, this._Length.position, this._Length.length);
        destination._Matches.set(destination.buffer, this._Matches.position, this._Matches.length);
        destination._MaxMessages.set(destination.buffer, this._MaxMessages.position, this._MaxMessages.length);
        destination._MessageId.set(destination.buffer, this._MessageId.position, this._MessageId.length);
        destination._Options.set(destination.buffer, this._Options.position, this._Options.length);
        destination._Password.set(destination.buffer, this._Password.position, this._Password.length);
        destination._QueryId.set(destination.buffer, this._QueryId.position, this._QueryId.length);
        destination._Reason.set(destination.buffer, this._Reason.position, this._Reason.length);
        destination._RecordsInserted.set(destination.buffer, this._RecordsInserted.position, this._RecordsInserted.length);
        destination._RecordsUpdated.set(destination.buffer, this._RecordsUpdated.position, this._RecordsUpdated.length);
        destination._RecordsDeleted.set(destination.buffer, this._RecordsDeleted.position, this._RecordsDeleted.length);
        destination._RecordsReturned.set(destination.buffer, this._RecordsReturned.position, this._RecordsReturned.length);
        destination._SendMatchingIds.set(destination.buffer, this._SendMatchingIds.position, this._SendMatchingIds.length);
        destination._SendOOF.set(destination.buffer, this._SendOOF.position, this._SendOOF.length);
        destination._Sequence.set(destination.buffer, this._Sequence.position, this._Sequence.length);
        destination._SowKey.set(destination.buffer, this._SowKey.position, this._SowKey.length);
        destination._SowKeys.set(destination.buffer, this._SowKeys.position, this._SowKeys.length);
        destination._Status.set(destination.buffer, this._Status.position, this._Status.length);
        destination._SubId.set(destination.buffer, this._SubId.position, this._SubId.length);
        destination._SubIds.set(destination.buffer, this._SubIds.position, this._SubIds.length);
        destination._Timestamp.set(destination.buffer, this._Timestamp.position, this._Timestamp.length);
        destination._Topic.set(destination.buffer, this._Topic.position, this._Topic.length);
        destination._TopicMatches.set(destination.buffer, this._TopicMatches.position, this._TopicMatches.length);
        destination._TopN.set(destination.buffer, this._TopN.position, this._TopN.length);
        destination._UserId.set(destination.buffer, this._UserId.position, this._UserId.length);
        destination._Version.set(destination.buffer, this._Version.position, this._Version.length);
        destination._bookmarkSeqNo = this._bookmarkSeqNo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SerializationResult {
        OK,
        BufferTooSmall;

    }

    public static final class Options {
        public static final String None = null;
        public static final String Live = "live,";
        public static final String OOF = "oof,";
        public static final String Replace = "replace,";
        public static final String NoEmpties = "no_empties,";
        public static final String SendKeys = "send_keys,";
    }

    public static final class Reason {
        public static final int None = 0;
        public static final int Duplicate = 1;
        public static final int BadFilter = 2;
        public static final int BadRegexTopic = 3;
        public static final int SubscriptionAlreadyExists = 4;
        public static final int Deleted = 5;
        public static final int Expired = 6;
        public static final int Match = 7;
        public static final int InvalidTopic = 8;
        public static final int NameInUse = 9;
        public static final int AuthFailure = 10;
        public static final int NotEntitled = 11;
        public static final int AuthDisabled = 12;
        public static final int InvalidBookmark = 13;
        public static final int InvalidOrderBy = 14;
        public static final int SubidInUse = 15;
        public static final int Other = 16;
    }

    public static final class Status {
        public static final int None = 0;
        public static final int Success = 1;
        public static final int Failure = 2;
        public static final int Retry = 3;
    }

    public static final class AckType {
        public static final int None = 0;
        public static final int Received = 1;
        public static final int Parsed = 2;
        public static final int Persisted = 4;
        public static final int Processed = 8;
        public static final int Completed = 16;
        public static final int Stats = 32;
    }

    public static final class Command {
        public static final int Unknown = 0;
        public static final int Publish = 1;
        public static final int Subscribe = 2;
        public static final int Unsubscribe = 4;
        public static final int SOW = 8;
        public static final int Heartbeat = 16;
        public static final int SOWDelete = 32;
        public static final int DeltaPublish = 64;
        public static final int Logon = 128;
        public static final int SOWAndSubscribe = 256;
        public static final int DeltaSubscribe = 512;
        public static final int SOWAndDeltaSubscribe = 1024;
        public static final int StartTimer = 2048;
        public static final int StopTimer = 4096;
        public static final int GroupBegin = 8192;
        public static final int GroupEnd = 16384;
        public static final int OOF = 32768;
        public static final int Ack = 65536;
        public static final int Flush = 131072;
    }
}

