/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Authenticator;
import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.ClientDisconnectHandler;
import com.crankuptheamps.client.ClientDisconnectHandler2;
import com.crankuptheamps.client.ConnectionInfo;
import com.crankuptheamps.client.DefaultDisconnectHandler;
import com.crankuptheamps.client.LoggedBookmarkStore;
import com.crankuptheamps.client.MemoryBookmarkStore;
import com.crankuptheamps.client.MemoryPublishStore;
import com.crankuptheamps.client.MemorySubscriptionManager;
import com.crankuptheamps.client.PublishStore;
import com.crankuptheamps.client.ServerChooser;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.exception.ConnectionException;
import com.crankuptheamps.client.exception.DisconnectedException;
import com.crankuptheamps.client.exception.StoreException;
import java.io.IOException;

public class HAClient
extends Client {
    private volatile boolean _disconnected = false;
    private static final int DefaultTimeout = 10000;
    private static final int DefaultReconnectInterval = 200;
    private int _timeout = 10000;
    private int _reconnectDelay = 200;
    private int _heartbeatInterval = 0;
    private int _readTimeout = 0;
    private volatile boolean _firstConnect = true;
    ServerChooser _serverChooser;
    HADisconnectHandler _disconnectHandler;

    public int getReconnectDelay() {
        return this._reconnectDelay;
    }

    public void setReconnectDelay(int reconnectInterval) {
        this._reconnectDelay = reconnectInterval;
    }

    public void setTimeout(int timeout_) {
        this._timeout = timeout_;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setHeartbeat(int intervalSeconds_, int timeoutSeconds_) throws DisconnectedException {
        this._heartbeatInterval = intervalSeconds_;
        this._readTimeout = timeoutSeconds_;
        super.setHeartbeat(intervalSeconds_, timeoutSeconds_);
    }

    public ServerChooser getServerChooser() {
        return this._serverChooser;
    }

    public void setServerChooser(ServerChooser serverChooser_) {
        this._serverChooser = serverChooser_;
    }

    public HAClient(String name) {
        super(name);
        super.setDisconnectHandler(new HADisconnectHandler());
        super.setSubscriptionManager(new MemorySubscriptionManager());
    }

    public static HAClient createMemoryBacked(String name) throws StoreException {
        HAClient client = new HAClient(name);
        client.setBookmarkStore(new MemoryBookmarkStore());
        client.setPublishStore(new MemoryPublishStore(10000));
        return client;
    }

    public static HAClient createFileBacked(String name, String publishLog, int initialPublishCapacity, String subscribeLog) throws IOException, StoreException {
        HAClient client = new HAClient(name);
        client.setBookmarkStore(new LoggedBookmarkStore(subscribeLog));
        client.setPublishStore(new PublishStore(publishLog, initialPublishCapacity));
        return client;
    }

    public static HAClient createFileBacked(String name, String publishLog, String subscribeLog) throws IOException, StoreException {
        HAClient client = new HAClient(name);
        client.setBookmarkStore(new LoggedBookmarkStore(subscribeLog));
        client.setPublishStore(new PublishStore(publishLog));
        return client;
    }

    public void connectAndLogon() throws ConnectionException {
        this._disconnected = false;
        while (true) {
            this.connectAndLogonInternal();
            try {
                this.getSubscriptionManager().resubscribe(this);
                return;
            }
            catch (AMPSException subException) {
                super.disconnect();
                this._serverChooser.reportFailure(subException, this.getConnectionInfo());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectAndLogonInternal() throws ConnectionException {
        block13: {
            if (this._serverChooser == null) {
                throw new ConnectionException("No server chooser registered with this HAClient.");
            }
            ClientDisconnectHandler currentHandler = super.getDisconnectHandler();
            super.setDisconnectHandler(new DefaultDisconnectHandler());
            while (true) {
                if (this._disconnected) break block13;
                String uri = this._serverChooser.getCurrentURI();
                if (uri == null) {
                    throw new ConnectionException("No AMPS instances available for connection. " + this._serverChooser.getError());
                }
                try {
                    if (!this._firstConnect) {
                        Thread.sleep(this._reconnectDelay);
                    } else {
                        this._firstConnect = false;
                    }
                    Authenticator authenticator = this._serverChooser.getCurrentAuthenticator();
                    super.connect(uri);
                    super.getTransport().getVersion();
                    super.logon(this._timeout, authenticator);
                    super.setHeartbeat(this._heartbeatInterval, this._readTimeout);
                    this._serverChooser.reportSuccess(this.getConnectionInfo());
                    return;
                }
                catch (Exception exception) {
                    ConnectionInfo ci = this.getConnectionInfo();
                    ci.put("client.uri", uri);
                    this._serverChooser.reportFailure(exception, ci);
                    try {
                        super.disconnect();
                    }
                    catch (Exception e) {
                        if (this.exceptionListener == null) continue;
                        this.exceptionListener.exceptionThrown(e);
                    }
                }
            }
            finally {
                super.setDisconnectHandler(currentHandler);
            }
        }
    }

    public void connect(String uri) throws ConnectionException {
        this._disconnected = false;
        this.connectAndLogon();
    }

    public void disconnect() {
        this._disconnected = true;
        super.disconnect();
    }

    public ConnectionInfo getConnectionInfo() {
        ConnectionInfo ci = super.getConnectionInfo();
        ci.put("haClient.reconnectDelay", this._reconnectDelay);
        ci.put("haClient.timeout", this._timeout);
        return ci;
    }

    public static class HADisconnectHandler
    implements ClientDisconnectHandler,
    ClientDisconnectHandler2 {
        public void invoke(Client client) {
        }

        public void invoke(Client client_, Exception e_) {
            this.invoke(client_);
            HAClient haClient = (HAClient)client_;
            haClient.getServerChooser().reportFailure(e_, client_.getConnectionInfo());
            try {
                haClient.connectAndLogonInternal();
            }
            catch (Exception e) {
                if (client_.exceptionListener != null) {
                    client_.exceptionListener.exceptionThrown(e);
                }
                return;
            }
        }
    }
}

