/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.FIXMessage;
import com.crankuptheamps.client.FIXProtocol;
import com.crankuptheamps.client.MessageHandler;
import com.crankuptheamps.client.ProtocolParser;
import com.crankuptheamps.client.exception.StreamException;
import java.nio.ByteBuffer;

public class FIXProtocolParser
implements ProtocolParser {
    private static final byte LATIN1_EQUALS_BYTE = 61;
    private static final byte LATIN1_ZERO_CHAR_BYTE = 48;
    private static final String LATIN1 = "ISO-8859-1";
    private FIXProtocol messageType = null;
    private FIXMessage message = null;
    private ByteBuffer buffer = null;
    private int remainingBytes = 0;
    private StreamState state;

    public FIXProtocolParser(FIXProtocol messageType) {
        this.messageType = messageType;
        this.message = messageType.allocateMessage();
    }

    public void process(ByteBuffer buffer, int remainingBytes, MessageHandler listener) throws StreamException {
        this.buffer = buffer;
        this.remainingBytes = remainingBytes;
        this.state = StreamState.start;
        this.message.reset();
        this.message.setBuffer(buffer.array());
        while (this.read(this.message)) {
            listener.invoke(this.message);
        }
    }

    private final void extractFieldValue(FIXMessage message) throws StreamException {
        if (this.remainingBytes < 6) {
            throw new StreamException("Stream corrupted: premature end of message header");
        }
        int tag = 0;
        for (int n = 0; n < 5; ++n) {
            byte c = this.getByte();
            tag = tag * 10 + (c - 48);
        }
        byte e = this.getByte();
        if (e != 61) {
            throw new StreamException("Stream corrupted: missing equals sign after FIX tag (found = " + e + ")");
        }
        int valueStart = this.buffer.position();
        int valueStop = -1;
        for (int n = valueStart; n < this.buffer.limit(); ++n) {
            if (this.getByte() != this.messageType.fieldSeparator) continue;
            valueStop = n;
            break;
        }
        if (valueStop == -1) {
            throw new StreamException("Stream corrupted: FIX value wasn't terminated with a field separator");
        }
        switch (tag - 20000) {
            case 0: {
                message._Command.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 1: {
                message._CommandId.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 2: {
                message._ClientName.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 3: {
                message._UserId.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 4: {
                message._Timestamp.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 5: {
                message._Topic.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 6: {
                message._Filter.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 8: {
                message._AckType.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 9: {
                message._SubId.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 11: {
                message._Version.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 12: {
                message._Expiration.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 13: {
                message._SendMatchingIds.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 18: {
                message._Status.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 19: {
                message._QueryId.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 23: {
                message._BatchSize.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 25: {
                message._TopN.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 35: {
                message._CorrelationId.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 36: {
                message._Sequence.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 37: {
                message._Bookmark.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 38: {
                message._Password.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 52: {
                message._RecordsInserted.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 53: {
                message._RecordsUpdated.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 54: {
                message._RecordsDeleted.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 55: {
                message._RecordsReturned.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 56: {
                message._TopicMatches.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 57: {
                message._Matches.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 58: {
                message._Length.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 59: {
                message._SowKey.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 60: {
                message._GroupSeqNo.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 61: {
                message._SubIds.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 62: {
                message._Reason.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
            case 63: {
                message._MessageId.set(this.buffer.array(), valueStart, valueStop - valueStart);
                break;
            }
        }
    }

    private void dumpBuffer(String prefix) {
        System.err.print(prefix);
        for (int j = this.buffer.position(); j < this.buffer.limit(); ++j) {
            byte c = this.buffer.get(j);
            if (c == this.messageType.fieldSeparator) {
                System.err.print("{fs}");
                continue;
            }
            if (c == this.messageType.headerSeparator) {
                System.err.print("{hs}");
                continue;
            }
            if (c == this.messageType.messageSeparator) {
                System.err.print("{ms}");
                continue;
            }
            try {
                System.err.print(new String(this.buffer.array(), j, 1, LATIN1));
                continue;
            }
            catch (Exception e) {
                System.err.print("{error}");
            }
        }
        System.err.println();
    }

    private final byte getByte() {
        --this.remainingBytes;
        return this.buffer.get();
    }

    private final byte peekByte() {
        return this.buffer.get(this.buffer.position());
    }

    private boolean read(FIXMessage m) throws StreamException {
        int messageLength;
        byte checkb;
        byte checkb2;
        if (this.remainingBytes <= 0) {
            return false;
        }
        m.setRawBufferOffset(this.buffer.position());
        while (this.remainingBytes > 0 && this.peekByte() != this.messageType.headerSeparator) {
            this.extractFieldValue(m);
            while (this.peekByte() == this.messageType.fieldSeparator) {
                this.getByte();
            }
        }
        if (this.remainingBytes > 0 && (checkb2 = this.getByte()) != this.messageType.headerSeparator) {
            throw new StreamException("stream corruption: expected header separator, but received byte: " + Integer.toString(checkb2));
        }
        int command = m.getCommand();
        if (this.state == StreamState.start && (command == 1 || command == 8 || command == 32768)) {
            while (this.remainingBytes > 0 && this.peekByte() != this.messageType.headerSeparator) {
                this.extractFieldValue(m);
                while (this.peekByte() == this.messageType.fieldSeparator) {
                    this.getByte();
                }
            }
            if (this.remainingBytes > 0 && (checkb = this.getByte()) != this.messageType.headerSeparator) {
                throw new StreamException("stream corruption: expected header separator, but received byte: " + Integer.toString(checkb));
            }
            this.state = StreamState.in_sow;
            messageLength = command == 1 || command == 32768 ? this.remainingBytes : m._Length.getValue();
        } else {
            messageLength = this.state == StreamState.in_sow ? m._Length.getValue() : this.remainingBytes;
        }
        m._Data.set(this.buffer.array(), this.buffer.position(), messageLength);
        this.remainingBytes -= messageLength;
        this.buffer.position(this.buffer.position() + messageLength);
        m.setRawBufferLength(this.buffer.position() - m.getRawBufferOffset());
        if (this.remainingBytes > 0 && (checkb = this.getByte()) != this.messageType.messageSeparator) {
            throw new StreamException("stream corruption: expected message separator, but received byte: " + Integer.toString(checkb));
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StreamState {
        start,
        in_sow,
        end;

    }
}

