/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.exception.CommandException;
import java.io.UnsupportedEncodingException;

public class FIXBuilder {
    private byte[] buffer = null;
    private int size = 0;
    private int capacity = 1024;
    private byte fieldSeparator;

    public FIXBuilder(int capacity, byte fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
        this.capacity = capacity;
        this.buffer = new byte[capacity];
    }

    public void clear() {
        this.size = 0;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getBytes() {
        return this.buffer;
    }

    private int ruLog10(int tag) {
        long scalar = 10L;
        for (int j = 1; j < 20; ++j) {
            if ((long)tag < scalar) {
                return j;
            }
            scalar *= 10L;
        }
        return 0;
    }

    private void checkCapacity(int bytesNeeded) {
        if (this.capacity - this.size < bytesNeeded) {
            while (this.capacity - this.size < bytesNeeded) {
                this.capacity *= 2;
            }
            byte[] newbuf = new byte[this.capacity];
            System.arraycopy(this.buffer, 0, newbuf, 0, this.size);
            this.buffer = newbuf;
        }
    }

    public FIXBuilder append(int tag, byte[] value, int offset, int length) throws CommandException {
        if (tag < 0) {
            throw new IllegalArgumentException("negative tag used in FIXBuilder");
        }
        int tagSize = this.ruLog10(tag);
        int sizeNeeded = tagSize + length + 2;
        this.checkCapacity(sizeNeeded);
        int writeIndex = this.size + tagSize;
        for (int j = 1; j <= tagSize; ++j) {
            this.buffer[writeIndex - j] = (byte)(48 + tag % 10);
            tag /= 10;
        }
        this.buffer[writeIndex] = 61;
        System.arraycopy(value, offset, this.buffer, ++writeIndex, length);
        this.buffer[writeIndex += length] = this.fieldSeparator;
        this.size += sizeNeeded;
        return this;
    }

    public FIXBuilder append(int tag, String value) throws CommandException {
        byte[] valueBytes;
        if (tag < 0) {
            throw new IllegalArgumentException("negative tag used in FIXBuilder");
        }
        int tagSize = this.ruLog10(tag);
        try {
            valueBytes = value.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ioex) {
            throw new CommandException("Unable to encode value '" + value + "' to byte array in FIXBuilder.\n" + ioex.toString());
        }
        int sizeNeeded = tagSize + valueBytes.length + 2;
        this.checkCapacity(sizeNeeded);
        int writeIndex = this.size + tagSize;
        for (int j = 1; j <= tagSize; ++j) {
            this.buffer[writeIndex - j] = (byte)(48 + tag % 10);
            tag /= 10;
        }
        this.buffer[writeIndex] = 61;
        System.arraycopy(valueBytes, 0, this.buffer, ++writeIndex, valueBytes.length);
        this.buffer[writeIndex += valueBytes.length] = this.fieldSeparator;
        this.size += sizeNeeded;
        return this;
    }
}

