/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.fields.CommandField;

public class Command {
    CommandId CommandId;
    CommandId QueryId;
    CommandId SubId;
    int Command;
    int AckType;
    String Filter;
    String OrderBy;
    String Bookmark;
    String Options;
    String SOWKeys;
    byte[] Topic;
    byte[] Data;
    String TopicString;
    String DataString;
    String CorrelationId;
    int _topicLength;
    int _topicOffset;
    int _dataLength;
    int _dataOffset;
    long Timeout = 0L;
    int TopN = -1;
    int BatchSize = 1;
    int Expiration = 0;
    boolean _expiration_isSet = false;
    long ClientSequenceNumber = 0L;
    Message _message = null;

    private void init() {
        this.SubId = null;
        this.QueryId = null;
        this.CommandId = null;
        this.CorrelationId = null;
        this.SOWKeys = null;
        this.Options = null;
        this.Bookmark = null;
        this.OrderBy = null;
        this.Filter = null;
        this.Data = null;
        this.Topic = null;
        this.DataString = null;
        this.TopicString = null;
        this.Expiration = 0;
        this.AckType = 0;
        this.TopN = -1;
        this.BatchSize = 1;
        this.ClientSequenceNumber = 0L;
        this.Timeout = 0L;
        this._expiration_isSet = false;
        if (this.Command != 1 && this.Command != 64 && this.Command != 2048) {
            this.CommandId = com.crankuptheamps.client.CommandId.nextIdentifier();
            if (this.isSow()) {
                this.QueryId = this.CommandId;
                if (this.Command == 8) {
                    this.AckType |= 0x10;
                }
            }
            if (this.isSubscribe()) {
                this.SubId = this.CommandId;
            }
            this.AckType |= 8;
        }
    }

    public String getSOWKeys() {
        return this.SOWKeys;
    }

    public Command setSOWKeys(String sowKeys) {
        this.SOWKeys = sowKeys;
        return this;
    }

    public boolean isSubscribe() {
        return this.Command == 512 || this.Command == 1024 || this.Command == 256 || this.Command == 2;
    }

    public boolean isSow() {
        return this.Command == 8 || this.Command == 1024 || this.Command == 256;
    }

    public boolean needsSequenceNumber() {
        return this.Command == 1 || this.Command == 64 || this.Command == 32;
    }

    private int translateCommand(String command_) throws IllegalArgumentException {
        CommandField cf = new CommandField();
        cf.set(command_.getBytes());
        if (!CommandField.encodeCommand(cf.getValue()).equals(command_)) {
            throw new IllegalArgumentException("unknown command type " + command_);
        }
        return cf.getValue();
    }

    public Command() {
    }

    public Command(int command_) {
        this.Command = command_;
        this.init();
    }

    public Command(String command_) {
        this.Command = this.translateCommand(command_);
        this.init();
    }

    public Command reset(int command_) {
        this.Command = command_;
        this.init();
        return this;
    }

    public Command reset(String command_) {
        this.Command = this.translateCommand(command_);
        this.init();
        return this;
    }

    public CommandId getCommandId() {
        return this.CommandId;
    }

    public Command setCommandId(CommandId commandId) {
        this.CommandId = commandId;
        return this;
    }

    public CommandId getQueryId() {
        return this.QueryId;
    }

    public Command setQueryId(CommandId queryId) {
        this.QueryId = queryId;
        return this;
    }

    public int getCommand() {
        return this.Command;
    }

    public Command setCommand(int command) {
        this.Command = command;
        return this;
    }

    public String getTopic() {
        return this.Topic != null ? new String(this.Topic, this._topicOffset, this._topicLength) : this.TopicString;
    }

    public Command setTopic(String topic) {
        this.TopicString = topic;
        this.Topic = null;
        return this;
    }

    public Command setTopic(byte[] topic, int offset, int length) {
        this.Topic = topic;
        this.TopicString = null;
        this._topicLength = length;
        this._topicOffset = 0;
        return this;
    }

    public String getFilter() {
        return this.Filter;
    }

    public Command setFilter(String filter) {
        this.Filter = filter;
        return this;
    }

    public String getOrderBy() {
        return this.OrderBy;
    }

    public Command setOrderBy(String orderBy) {
        this.OrderBy = orderBy;
        return this;
    }

    public CommandId getSubId() {
        return this.SubId;
    }

    public Command setSubId(CommandId subId) {
        if (subId != null) {
            this.SubId = subId;
        }
        return this;
    }

    public Command setSubId(String subId) {
        if (subId != null) {
            this.SubId = new CommandId(subId);
        }
        return this;
    }

    public String getBookmark() {
        return this.Bookmark;
    }

    public Command setBookmark(String bookmark) {
        this.Bookmark = bookmark;
        return this;
    }

    public String getOptions() {
        return this.Options;
    }

    public Command setOptions(String options) {
        this.Options = options;
        return this;
    }

    public int getAckType() {
        return this.AckType;
    }

    public Command setAckType(int ackType) {
        this.AckType = ackType;
        return this;
    }

    public Command addAckType(int ackType) {
        this.AckType |= ackType;
        return this;
    }

    public String getData() {
        return this.Data != null ? new String(this.Data, this._dataOffset, this._dataLength) : this.DataString;
    }

    public Command setData(String data) {
        this.DataString = data;
        this.Data = null;
        return this;
    }

    public Command setData(byte[] data, int offset, int length) {
        this.DataString = null;
        this.Data = data;
        this._dataOffset = offset;
        this._dataLength = length;
        return this;
    }

    public long getTimeout() {
        return this.Timeout;
    }

    public Command setTimeout(long timeout) {
        this.Timeout = timeout;
        return this;
    }

    public int getTopN() {
        return this.TopN;
    }

    public Command setTopN(int topN) {
        this.TopN = topN;
        return this;
    }

    public int getBatchSize() {
        return this.BatchSize;
    }

    public Command setBatchSize(int batchSize) {
        this.BatchSize = batchSize;
        return this;
    }

    public int getExpiration() {
        if (!this._expiration_isSet) {
            return 0;
        }
        return this.Expiration;
    }

    public boolean hasExpiration() {
        return this._expiration_isSet;
    }

    public Command setExpiration(int expiration) {
        this.Expiration = expiration;
        this._expiration_isSet = true;
        return this;
    }

    public void unsetExpiration() {
        this._expiration_isSet = false;
    }

    protected CommandId prepare(Client client_) {
        if (this._message == null) {
            this._message = client_.allocateMessage();
        } else {
            this._message.reset();
        }
        this._message.setCommand(this.Command);
        if (this.CommandId != null) {
            this._message.setCommandId(this.CommandId);
        }
        this._message.setAckType(this.AckType);
        if (this.Bookmark != null) {
            this._message.setBookmark(this.Bookmark);
        }
        if (this.Data != null) {
            this._message.setData(this.Data, this._dataOffset, this._dataLength);
        } else if (this.DataString != null) {
            this._message.setData(this.DataString);
        }
        if (this.Filter != null) {
            this._message.setFilter(this.Filter);
        }
        if (this.Options != null) {
            this._message.setOptions(this.Options);
        }
        if (this.OrderBy != null) {
            this._message.setOrderBy(this.OrderBy);
        }
        if (this.QueryId != null) {
            this._message.setQueryId(this.QueryId);
        }
        if (this.SubId != null) {
            this._message.setSubId(this.SubId);
        }
        if (this.Topic != null) {
            this._message.setTopic(this.Topic, this._topicOffset, this._topicLength);
        } else if (this.TopicString != null) {
            this._message.setTopic(this.TopicString);
        }
        if (this._expiration_isSet) {
            this._message.setExpiration(this.Expiration);
        }
        if (this.SOWKeys != null) {
            this._message.setSowKeys(this.SOWKeys);
        }
        if (this.isSubscribe()) {
            this._message.setSendMatchingIds(true);
        }
        if (this.BatchSize != 1) {
            this._message.setBatchSize(this.BatchSize);
        }
        if (this.TopN != -1) {
            this._message.setTopN(this.TopN);
        }
        if (this.CorrelationId != null) {
            this._message.setCorrelationId(this.CorrelationId);
        }
        return this.CommandId;
    }

    protected Command setClientSequenceNumber(long seqNumber) {
        this.ClientSequenceNumber = seqNumber;
        return this;
    }

    public long getClientSequenceNumber() {
        return this.ClientSequenceNumber;
    }

    public Command setCorrelationId(String correlationId_) {
        this.CorrelationId = correlationId_;
        return this;
    }

    public String getCorrelationId() {
        return this.CorrelationId;
    }
}

