/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.ArrayStoreBuffer;
import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.PublishStoreResizeHandler;
import com.crankuptheamps.client.Store;
import com.crankuptheamps.client.exception.DisconnectedException;
import com.crankuptheamps.client.exception.StoreException;
import com.crankuptheamps.client.exception.TimedOutException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.zip.CRC32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockPublishStore
implements Store {
    private int _blocksPerRealloc = 10000;
    ReadWriteLock _bufferLock;
    protected Buffer _buffer;
    Block _freeList;
    Block _usedList;
    Block _endOfUsedList;
    CRC32 _crc = null;
    ByteSequence _argument = new ByteSequence();
    ByteSequence _commandId = new ByteSequence();
    ByteSequence _correlationId = new ByteSequence();
    byte[] _readBuffer;
    volatile int _usedCount;
    ArrayStoreBuffer _sb = null;
    protected static final int HAS_EXTENDED_METADATA = 4;

    protected BlockPublishStore(Buffer buffer, int blocksPerRealloc, boolean isAFile) {
        this._blocksPerRealloc = blocksPerRealloc;
        this._buffer = buffer;
        if (isAFile) {
            this._crc = new CRC32();
            this._sb = new ArrayStoreBuffer();
            try {
                this._sb.setSize(2048L);
            }
            catch (Exception e) {
                this._sb = null;
            }
        }
    }

    protected BlockPublishStore(Buffer buffer, int blocksPerRealloc) {
        this(buffer, blocksPerRealloc, true);
    }

    protected BlockPublishStore(Buffer buffer) {
        this(buffer, 10000);
    }

    @Override
    public void store(long index, int operation, byte[] topic, long topicOffset, long topicLength, byte[] data, long dataOffset, long dataLength, byte[] correlationId, long correlationIdOffset, long correlationIdLength) throws StoreException {
        this._store(index, operation, topic, topicOffset, topicLength, data, dataOffset, dataLength, correlationId, correlationIdOffset, correlationIdLength, 0, false, null);
    }

    @Override
    public void store(long index, int operation, byte[] topic, long topicOffset, long topicLength, byte[] data, long dataOffset, long dataLength, byte[] correlationId, long correlationIdOffset, long correlationIdLength, int expiration) throws StoreException {
        this._store(index, operation, topic, topicOffset, topicLength, data, dataOffset, dataLength, correlationId, correlationIdOffset, correlationIdLength, expiration, true, null);
    }

    @Override
    public void store(long index, int operation, byte[] topic, long topicOffset, long topicLength, byte[] data, long dataOffset, long dataLength, int flag, CommandId cmdId) throws StoreException {
        this._store(index, operation, topic, topicOffset, topicLength, data, dataOffset, dataLength, null, 0L, 0L, flag, true, cmdId);
    }

    protected synchronized void _store(long index, int operation, byte[] topic, long topicOffset, long topicLength, byte[] data, long dataOffset, long dataLength, byte[] correlationId, long correlationIdOffset, long correlationIdLength, int expiration, boolean expirationIsValid, CommandId commandId) throws StoreException {
        boolean hasExtendedMetadata;
        long topicRemaining = topicLength;
        long dataRemaining = dataLength;
        long totalRemaining = topicLength + 5L + dataLength;
        boolean bl = hasExtendedMetadata = correlationIdLength > 0L || expirationIsValid || commandId != null;
        if (hasExtendedMetadata) {
            totalRemaining += 12L + correlationIdLength;
            if (commandId != null) {
                totalRemaining += (long)commandId.id.length;
            }
        }
        int lastBlockLength = (int)(totalRemaining % 2016L);
        int blocksToWrite = (int)(totalRemaining / 2016L) + (lastBlockLength > 0 ? 1 : 0);
        long crcVal = 0L;
        if (this._crc != null) {
            this._crc.reset();
            this._crc.update(topic, (int)topicOffset, (int)topicLength);
            this._crc.update(data, (int)dataOffset, (int)dataLength);
            crcVal = this._crc.getValue();
        }
        try {
            Block next;
            Block first = next = this.get();
            if (first == null) {
                throw new StoreException("The store is full, and no blocks can be allocated.");
            }
            first.sequenceNumber = index;
            while (blocksToWrite > 0) {
                long topicBytesToWrite;
                Block current = next;
                int bytesRemainingInBlock = 2016;
                if (blocksToWrite > 1) {
                    next = this.get();
                    if (next == null) {
                        throw new StoreException("The store is full, and no additional blocks can be allocated.");
                    }
                } else {
                    next = null;
                }
                current.nextInChain = next;
                current.nextInList = null;
                Buffer buffer = this._sb == null ? this._buffer : this._sb;
                long start = this._sb == null ? current.getPosition() : 0L;
                buffer.setPosition(start);
                if (current == first) {
                    buffer.putInt((int)totalRemaining);
                } else {
                    buffer.putInt(next == null ? lastBlockLength : 2016);
                }
                buffer.putInt(next == null ? current.index : next.index);
                buffer.putLong(current == first ? index : 0L);
                buffer.putLong(crcVal);
                buffer.setPosition(start + 32L);
                if (current == first) {
                    int commandIdLength;
                    int n = commandIdLength = commandId != null ? commandId.id.length : 0;
                    if (hasExtendedMetadata) {
                        buffer.putByte((byte)(operation & 0xFF | 4));
                        buffer.putInt((int)topicLength);
                        buffer.putInt(expiration);
                        bytesRemainingInBlock -= 9;
                        buffer.putInt(commandIdLength);
                        bytesRemainingInBlock -= 4;
                        if (commandIdLength > 0) {
                            this._commandId.array = commandId.id;
                            this._commandId.offset = 0L;
                            this._commandId.len = commandIdLength;
                            buffer.putBytes(this._commandId);
                            bytesRemainingInBlock -= commandIdLength;
                        }
                        buffer.putInt((int)correlationIdLength);
                        bytesRemainingInBlock -= 4;
                        if (correlationIdLength > 0L) {
                            this._argument.array = correlationId;
                            this._argument.offset = correlationIdOffset;
                            this._argument.len = correlationIdLength;
                            buffer.putBytes(this._argument);
                            bytesRemainingInBlock = (int)((long)bytesRemainingInBlock - correlationIdLength);
                        }
                    } else {
                        buffer.putByte((byte)(operation & 0xFF));
                        buffer.putInt((int)topicLength);
                        bytesRemainingInBlock -= 5;
                    }
                }
                long l = topicBytesToWrite = topicRemaining <= (long)bytesRemainingInBlock ? topicRemaining : (long)bytesRemainingInBlock;
                if (topicBytesToWrite > 0L) {
                    this._argument.array = topic;
                    this._argument.offset = topicOffset + (topicLength - topicRemaining);
                    this._argument.len = topicBytesToWrite;
                    buffer.putBytes(this._argument);
                    bytesRemainingInBlock = (int)((long)bytesRemainingInBlock - topicBytesToWrite);
                    topicRemaining -= topicBytesToWrite;
                }
                if (topicRemaining == 0L) {
                    long dataBytesToWrite;
                    long l2 = dataBytesToWrite = dataRemaining <= (long)bytesRemainingInBlock ? dataRemaining : (long)bytesRemainingInBlock;
                    assert (dataBytesToWrite != 0L);
                    this._argument.array = data;
                    this._argument.offset = dataOffset + (dataLength - dataRemaining);
                    this._argument.len = dataBytesToWrite;
                    buffer.putBytes(this._argument);
                    bytesRemainingInBlock = (int)((long)bytesRemainingInBlock - dataBytesToWrite);
                    dataRemaining -= dataBytesToWrite;
                }
                if (this._sb != null) {
                    this._buffer.setPosition(current.getPosition());
                    this._argument.array = this._sb.getBuffer();
                    this._argument.offset = 0L;
                    this._argument.len = this._sb.getPosition();
                    this._buffer.putBytes(this._argument);
                }
                --blocksToWrite;
            }
            assert (dataRemaining == 0L && topicRemaining == 0L);
            first.nextInList = null;
            if (this._endOfUsedList != null) {
                this._endOfUsedList.nextInList = first;
                this._endOfUsedList = first;
            } else {
                this._endOfUsedList = this._usedList = first;
            }
            ++this._usedCount;
        }
        catch (IOException e) {
            throw new StoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discardUpTo(long index) throws StoreException {
        Block almostFreeList = this.detach(index);
        Block zeroedOutList = null;
        Block lastOnTheList = almostFreeList;
        try {
            Block current = almostFreeList;
            while (current != null) {
                Block next = current.nextInList;
                Block currentInChain = current;
                while (currentInChain != null) {
                    Block nextInChain = currentInChain.nextInChain;
                    this._buffer.zero(currentInChain.getPosition(), 32);
                    currentInChain.sequenceNumber = 0L;
                    currentInChain.nextInChain = null;
                    currentInChain.nextInList = zeroedOutList;
                    zeroedOutList = currentInChain;
                    currentInChain = nextInChain;
                }
                current = next;
            }
        }
        catch (IOException ioex) {
            throw new StoreException(ioex);
        }
        BlockPublishStore blockPublishStore = this;
        synchronized (blockPublishStore) {
            if (lastOnTheList != null) {
                lastOnTheList.nextInList = this._freeList;
                this._freeList = zeroedOutList;
            }
        }
    }

    @Override
    public long getLowestUnpersisted() {
        if (this._usedList != null) {
            return this._usedList.sequenceNumber;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block detach(long index) {
        Block keepList = null;
        Block endOfDiscardList = null;
        Block discardList = null;
        BlockPublishStore blockPublishStore = this;
        synchronized (blockPublishStore) {
            keepList = this._usedList;
            while (keepList != null && keepList.sequenceNumber <= index) {
                if (discardList == null) {
                    discardList = keepList;
                }
                endOfDiscardList = keepList;
                keepList = keepList.nextInList;
                --this._usedCount;
            }
            if (endOfDiscardList != null) {
                endOfDiscardList.nextInList = null;
            }
            this._usedList = keepList;
            if (keepList == null) {
                this._endOfUsedList = null;
            }
            this.notifyAll();
        }
        return discardList;
    }

    private void replayOnto(Block b, Store.StoreReplayer replayer) throws IOException, DisconnectedException {
        this._buffer.setPosition(b.getPosition());
        int totalLength = this._buffer.getInt() - 5;
        if (totalLength <= 0) {
            return;
        }
        this._buffer.getInt();
        long index = this._buffer.getLong();
        long crcVal = this._buffer.getLong();
        this._buffer.setPosition(b.getPosition() + 32L);
        int operation = this._buffer.getByte();
        int topicLength = this._buffer.getInt();
        int expiration = -1;
        CommandId cmdId = null;
        if (((byte)operation & 4) > 0) {
            expiration = this._buffer.getInt();
            operation &= 0xFFFFFFFB;
            totalLength -= 4;
            this._commandId.len = this._buffer.getInt();
            totalLength -= 4;
            this._buffer.getBytes(this._commandId);
            cmdId = new CommandId(this._commandId.array, (int)this._commandId.offset, (int)this._commandId.len);
            totalLength -= (int)this._commandId.len;
            this._correlationId.len = this._buffer.getInt();
            totalLength -= 4;
            this._buffer.getBytes(this._correlationId);
            totalLength -= (int)this._correlationId.len;
        }
        int expectedDataLength = totalLength - topicLength;
        if (b.nextInChain == null) {
            this._argument.len = totalLength;
            this._buffer.getBytes(this._argument);
            if (this._crc != null) {
                this._crc.reset();
                try {
                    this._crc.update(this._argument.array, (int)this._argument.offset, topicLength);
                    this._crc.update(this._argument.array, (int)this._argument.offset + topicLength, expectedDataLength);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this._crc.getValue() != crcVal) {
                    String message = String.format("Corrupted message found.  Block index %d, sequence %d, topic length %d, expected data length %d, expected CRC %d, actual CRC %d", b.index, b.sequenceNumber, topicLength, expectedDataLength, crcVal, this._crc.getValue());
                    throw new IOException(message);
                }
            }
            if (expiration == -1) {
                replayer.execute(index, operation, this._argument.array, this._argument.offset, topicLength, this._argument.array, this._argument.offset + (long)topicLength, expectedDataLength, this._correlationId.array, this._correlationId.offset, this._correlationId.len);
            } else if (operation == 1 || operation == 64) {
                replayer.execute(index, operation, this._argument.array, this._argument.offset, topicLength, this._argument.array, this._argument.offset + (long)topicLength, expectedDataLength, this._correlationId.array, this._correlationId.offset, this._correlationId.len, expiration);
            } else {
                replayer.execute(index, operation, this._argument.array, this._argument.offset, topicLength, this._argument.array, this._argument.offset + (long)topicLength, expectedDataLength, expiration, cmdId);
            }
        } else {
            if (this._readBuffer == null || this._readBuffer.length < totalLength) {
                this._readBuffer = new byte[totalLength];
            }
            int offset = 0;
            Block part = b;
            while (part != null) {
                if (b != part) {
                    this._buffer.setPosition(part.getPosition() + 32L);
                }
                int maxReadable = 2016;
                if (part == b) {
                    maxReadable -= 5;
                }
                int readLen = totalLength - offset > maxReadable ? maxReadable : totalLength - offset;
                this._argument.len = readLen;
                try {
                    this._buffer.getBytes(this._argument);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.arraycopy(this._argument.array, (int)this._argument.offset, this._readBuffer, offset, readLen);
                offset += readLen;
                part = part.nextInChain;
            }
            if (offset != totalLength) {
                throw new IOException(String.format("Corrupted message found.  Expected %d bytes, read %d bytes.", totalLength, offset));
            }
            if (this._crc != null) {
                this._crc.reset();
                try {
                    this._crc.update(this._readBuffer, 0, topicLength);
                    this._crc.update(this._readBuffer, topicLength, offset - topicLength);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this._crc.getValue() != crcVal) {
                    StringBuilder sb = new StringBuilder();
                    Block part2 = b;
                    while (part2 != null) {
                        sb.append(part2.toString());
                        sb.append('\n');
                        part2 = part2.nextInChain;
                    }
                    throw new IOException(String.format("Corrupted multi-block message found in store. Topic Length %d, Data Length %d, BlockList:%n", topicLength, offset - topicLength) + sb.toString());
                }
            }
            if (expiration == -1) {
                replayer.execute(index, operation, this._readBuffer, 0L, topicLength, this._readBuffer, topicLength, offset - topicLength, this._correlationId.array, this._correlationId.offset, this._correlationId.len);
            } else if (operation == 1 || operation == 64) {
                replayer.execute(index, operation, this._readBuffer, 0L, topicLength, this._readBuffer, topicLength, offset - topicLength, this._correlationId.array, this._correlationId.offset, this._correlationId.len, expiration);
            } else {
                replayer.execute(index, operation, this._readBuffer, 0L, topicLength, this._readBuffer, topicLength, offset - topicLength, expiration, cmdId);
            }
        }
    }

    @Override
    public synchronized void replay(Store.StoreReplayer replayer) throws StoreException, DisconnectedException {
        try {
            Block b = this._usedList;
            while (b != null) {
                this.replayOnto(b, replayer);
                b = b.nextInList;
            }
        }
        catch (IOException ioex) {
            throw new StoreException(ioex);
        }
    }

    @Override
    public synchronized void replaySingle(Store.StoreReplayer replayer, long index) throws StoreException, DisconnectedException {
        try {
            Block b = this._usedList;
            while (b != null) {
                if (b.sequenceNumber == index) {
                    this.replayOnto(b, replayer);
                    return;
                }
                b = b.nextInList;
            }
        }
        catch (IOException ioex) {
            throw new StoreException(ioex);
        }
    }

    @Override
    public long unpersistedCount() {
        return this._usedCount;
    }

    Block findOrCreate(long index, HashMap<Long, Block> allBlocks) {
        if (allBlocks.containsKey(index)) {
            return allBlocks.get(index);
        }
        Block b = new Block((int)index);
        allBlocks.put(index, b);
        return b;
    }

    protected synchronized void recover() throws StoreException {
        this._freeList = null;
        this._usedList = null;
        this._usedCount = 0;
        HashMap<Long, Block> allBlocks = new HashMap<Long, Block>();
        TreeMap<Long, Block> heads = new TreeMap<Long, Block>();
        try {
            long end = this._buffer.getSize();
            for (long offset = 0L; offset < end; offset += 2048L) {
                long index = offset / 2048L;
                Block b = this.findOrCreate(index, allBlocks);
                this._buffer.setPosition(offset);
                int size = this._buffer.getInt();
                int nextIndex = this._buffer.getInt();
                b.nextInChain = size == 0 || (long)nextIndex == index ? null : this.findOrCreate(nextIndex, allBlocks);
                long sequence = this._buffer.getLong();
                if (size == 0) {
                    b.nextInList = this._freeList;
                    this._freeList = b;
                    continue;
                }
                if (sequence == 0L) continue;
                b.sequenceNumber = sequence;
                heads.put(sequence, b);
            }
            for (Map.Entry e : heads.entrySet()) {
                Block b = (Block)e.getValue();
                b.nextInList = null;
                if (this._endOfUsedList != null) {
                    this._endOfUsedList.nextInList = b;
                    this._endOfUsedList = b;
                } else {
                    this._usedList = this._endOfUsedList = b;
                }
                ++this._usedCount;
            }
        }
        catch (IOException ioex) {
            throw new StoreException(ioex);
        }
    }

    protected void growFreeListIfEmpty() throws StoreException {
        if (this._freeList != null) {
            return;
        }
        try {
            long oldSize = this._buffer.getSize();
            long newSize = oldSize + 2048L * (long)this._blocksPerRealloc;
            if (newSize > Integer.MAX_VALUE) {
                throw new StoreException("PublishStore capacity exceeded");
            }
            while (this._buffer.getSize() == oldSize) {
                this._buffer.setSize(newSize);
                if (this._freeList == null) continue;
                return;
            }
            if (this._buffer.getSize() < newSize) {
                throw new StoreException("Publish store could not resize, possibly due to resize handler.");
            }
            for (int idx = (int)(oldSize / 2048L); idx < (int)(newSize / 2048L); ++idx) {
                Block b = new Block(idx);
                this._buffer.zero(b.getPosition(), 2048);
                b.nextInChain = null;
                b.nextInList = this._freeList;
                this._freeList = b;
            }
        }
        catch (IOException e) {
            throw new StoreException(e);
        }
    }

    @Override
    public synchronized void flush() throws TimedOutException {
        if (this._usedList == null) {
            return;
        }
        long current = this._endOfUsedList.sequenceNumber;
        while (this._usedList != null && current >= this._usedList.sequenceNumber) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public synchronized void flush(long timeout) throws TimedOutException {
        if (this._usedList == null) {
            return;
        }
        long current = this._endOfUsedList.sequenceNumber;
        long start = System.currentTimeMillis();
        long end = System.currentTimeMillis();
        while (this._usedList != null && current >= this._usedList.sequenceNumber && end - start < timeout) {
            try {
                long remaining = timeout - (end - start);
                this.wait(remaining);
                end = System.currentTimeMillis();
                if (end - start < timeout) continue;
                throw new TimedOutException("Timed out waiting to flush publish store.");
            }
            catch (InterruptedException e) {
            }
        }
        if (this._usedList != null && current >= this._usedList.sequenceNumber && end - start >= timeout) {
            throw new TimedOutException("Timed out waiting to flush publish store.");
        }
    }

    @Override
    public void setResizeHandler(PublishStoreResizeHandler handler) {
        this._buffer.setResizeHandler(handler, this);
    }

    private Block get() throws StoreException {
        this.growFreeListIfEmpty();
        Block b = this._freeList;
        if (b != null) {
            this._freeList = b.nextInList;
        }
        return b;
    }

    static class Block {
        public int index;
        public Block nextInChain;
        public Block nextInList;
        public long sequenceNumber;
        public static final int SIZE = 2048;
        public static final int BLOCK_HEADER_SIZE = 32;
        public static final int BLOCK_DATA_SIZE = 2016;
        public static final int CHAIN_HEADER = 5;

        public Block(int index) {
            this.index = index;
        }

        public long getPosition() {
            return 2048 * this.index;
        }

        public String toString() {
            return String.format("block %d sequenceNumber %d", this.index, this.sequenceNumber);
        }
    }

    public static interface Buffer {
        public long getSize() throws IOException;

        public void setSize(long var1) throws IOException;

        public long getPosition() throws IOException;

        public void setPosition(long var1) throws IOException;

        public void putByte(byte var1) throws IOException;

        public byte getByte() throws IOException;

        public void putInt(int var1) throws IOException;

        public int getInt() throws IOException;

        public void putLong(long var1) throws IOException;

        public long getLong() throws IOException;

        public void putBytes(ByteSequence var1) throws IOException;

        public void getBytes(ByteSequence var1) throws IOException;

        public void zero(long var1, int var3) throws IOException;

        public void setResizeHandler(PublishStoreResizeHandler var1, Store var2);
    }

    public static class ByteSequence {
        public byte[] array;
        public long offset;
        public long len;

        public ByteSequence() {
            this.array = null;
            this.len = 0L;
            this.offset = 0L;
        }

        public ByteSequence(byte[] array, long offset, long len) {
            this.array = array;
            this.offset = offset;
            this.len = len;
        }
    }
}

